import json
import os
import unittest


class TestCommonPrediction(unittest.TestCase):
    maxDiff = None

    def test_mismatch(self):
        cmd="python src/match.py  -j test_data/mismatch/input.json -o test_data/mismatch/output -f json"
        with os.popen(cmd) as process:
            printed_result = process.read()

        with open('test_data/mismatch/output.json','r') as f:
            result = json.load(f)
        with open('test_data/mismatch/expected_output.json','r') as f:
            expected_output = json.load(f)
            expected_output = expected_output['results'][0]
        if "results" in result:
            result = result["results"][0]

        self.assertEqual(sorted(result['table_data']), sorted(expected_output['table_data']))


    def test_best_match(self):
        cmd="python src/match.py  -j test_data/best_match/input.json -o test_data/best_match/output -f json"
        with os.popen(cmd) as process:
            printed_result = process.read()

        with open('test_data/best_match/output.json','r') as f:
            result = json.load(f)
        with open('test_data/best_match/expected_output.json','r') as f:
            expected_output = json.load(f)
            expected_output = expected_output['results'][0]
        if "results" in result:
            result = result["results"][0]

        self.assertEqual(sorted(result['table_data']), sorted(expected_output['table_data']))


    def test_exact_match(self):
        cmd="python src/match.py  -j test_data/exact_match/input.json -o test_data/exact_match/output -f json"
        with os.popen(cmd) as process:
            printed_result = process.read()

        with open('test_data/exact_match/output.json','r') as f:
            result = json.load(f)
        with open('test_data/exact_match/expected_output.json','r') as f:
            expected_output = json.load(f)
            expected_output = expected_output['results'][0]
        if "results" in result:
            result = result["results"][0]

        self.assertEqual(sorted(result['table_data']), sorted(expected_output['table_data']))


    def test_no_match(self):
        cmd="python src/match.py  -j test_data/no_match/input.json -o test_data/no_match/output -f json"
        with os.popen(cmd) as process:
            printed_result = process.read()
            
        with open('test_data/no_match/output.json','r') as f:
            result = json.load(f)
        with open('test_data/no_match/expected_output.json','r') as f:
            expected_output = json.load(f)
            expected_output = expected_output['results'][0]
        if "results" in result:
            result = result["results"][0]

        self.assertEqual(sorted(result['table_data']), sorted(expected_output['table_data']))


if __name__=='__main__':
    unittest.main()