import sys
import unittest
from pathlib import Path
PROJECT_DIR = str(Path(__file__).resolve().parents[1])
sys.path.insert(1, PROJECT_DIR)
from allele_validator import AlleleValidator

class TestAvailableAlleles(unittest.TestCase):
    validator = AlleleValidator()

    def test_positive_cases(self):        
        '''True Case: Simple + Input/Return type agreement'''
        result = self.validator.get_available_alleles(method='icerfire', tools_group='pvc')
        result_first_ten = result[:10]
        result_last_ten = result[-10:]
        exp_result_first_ten = ['HLA-A*01:01', 'HLA-A*02:01', 'HLA-A*02:02', 'HLA-A*02:03', 'HLA-A*02:05', 'HLA-A*02:06', 'HLA-A*02:10', 'HLA-A*02:11', 'HLA-A*02:24', 'HLA-A*03:01']
        exp_result_last_ten = ['HLA-C*05:01', 'HLA-C*06:02', 'HLA-C*07:01', 'HLA-C*07:02', 'HLA-C*08:02', 'HLA-C*12:02', 'HLA-C*12:03', 'HLA-C*14:02', 'HLA-C*14:03', 'HLA-C*15:02']
        self.assertEqual(exp_result_first_ten, result_first_ten)
        self.assertEqual(exp_result_last_ten, result_last_ten)

        result = self.validator.get_available_alleles(method='netmhciipan', version='4.1', tools_group='mhcii')
        result_first_ten = result[:10]
        result_last_ten = result[-10:]
        exp_result_first_ten = ['HLA-DPA1*01:03/DPB1*01:01', 'HLA-DPA1*01:03/DPB1*02:01', 'HLA-DPA1*01:03/DPB1*02:02', 'HLA-DPA1*01:03/DPB1*03:01', 'HLA-DPA1*01:03/DPB1*04:01', 'HLA-DPA1*01:03/DPB1*04:02', 'HLA-DPA1*01:03/DPB1*05:01', 'HLA-DPA1*01:03/DPB1*06:01', 'HLA-DPA1*01:03/DPB1*08:01', 'HLA-DPA1*01:03/DPB1*09:01']
        # exp_result_last_ten = ['HLA-DRB5*02:04', 'HLA-DRB5*02:05', 'H2-IAb', 'H2-IAd', 'H2-IAk', 'H2-IAq', 'H2-IAs', 'H2-IAu', 'H2-IEd', 'H2-IEk']
        exp_result_last_ten = ['HLA-DPA1*01:06', 'HLA-DPB1*130:01', 'HLA-DPB1*38:01', 'HLA-DQB1*06:12', 'HLA-DQB1*03:14', 'HLA-DPB1*105:01', 'HLA-DQA1*01:04', 'HLA-DPB1*99:01', 'HLA-DQB1*06:29', 'HLA-DQB1*06:04']
        self.assertEqual(exp_result_first_ten, result_first_ten)
        self.assertEqual(exp_result_last_ten, result_last_ten)

if __name__ == "__main__":
    unittest.main()