#!/bin/bash

# This the main ICERFIRE-1.0 script. It acts as the full pipeline, doing the NetMHCpan, KernDist, PepX query, and Python script
# Yat-tsai Richie Wan, Jul 2023


# SET-UP :
# Replace USERDIR with the directory path containing your standalone of ICERFIRE-1.0
#USERDIR="/home/jyan/tttest/peptide-variant-comparison/src/ICERFIRE/"

# set where to store temporary files (must be writable to all users)
export TMPDIR=`mktemp -d`

# Get the absolute path of the script
SCRIPT_PATH=$(realpath "${BASH_SOURCE[0]}")

# Get the directory of the script
SCRIPT_DIR=$(dirname "$SCRIPT_PATH")

# Get the parent directory of the script's directory
USERDIR=$(dirname "$SCRIPT_DIR")

# Print the script's path, directory, and parent directory
echo "Script Path: $SCRIPT_PATH"
echo "Script Directory: $SCRIPT_DIR"
echo "Parent Directory: $USERDIR"

#source "$USERDIR/.env"

echo "PEPXDBPATH: $PEPXDBPATH"
echo "NETMHCPANPATH: $NETMHCPANPATH"

# Replace PEPXDIR with the path to the folder containing the database file pepx-export.db
# Still need it?
#PEPXDIR="${USERDIR}/pepx/"
# Replace NETMHCPAN with the path to the binary of netMHCpan-4.1
#NETMHCPAN="/home/jyan/workspace/iedb/gitlab/standalone/build_standalone/mhc_i/method/netmhcpan-4.1-executable/netmhcpan_4_1_executable/netMHCpan"
NETMHCPAN=$NETMHCPANPATH

# Define the characters that can be used
characters="abcdefghijkmnopqrstuvwxyzABCDEFGHJKLMNOPQRSTUVWXYZ0123456789"
# Generate a random index between 0 and 61 (total number of characters)
index=$((RANDOM % 60))
# Get the character at the generated index
first_char="${characters:index:1}"
# Generate the remaining 4 characters as a combination of the defined characters
rest_chars=$(head /dev/urandom | tr -dc "$characters" | head -c 4)
# Combine the first and remaining characters
JOBID="${first_char}${rest_chars}"

while getopts ":f:a:u:" opt; do
  case ${opt} in
    f )
      FILENAME=$OPTARG
      ;;
    a )
      ADD_EXPR=$OPTARG
      ;;
    u )
      USER_EXPR=$OPTARG
      ;;
    \? )
      echo "Usage: $0 -f <file_path> -a <add_expr> (true/false) -u <user_exp> (true/false)"
      exit 1
      ;;
    : )
      echo "Invalid option: -$OPTARG requires an argument"
      exit 1
      ;;
  esac
done


# Shift the processed options so that $1, $2, etc. now refer to non-option arguments
shift $((OPTIND - 1))

# Access the values using the variable names
echo "File Path: $file_path"
echo "Add Expression: $add_expr"
echo "User Expression: $user_exp"

if [ -z "$FILENAME" ] || [ -z "$ADD_EXPR" ] || [ -z "$USER_EXPR" ]; then
  echo "Error: Missing required variables. Please provide values for file_path, add_expr, and user_exp."
  echo "Usage: $0 -f <file_path> -a <add_expr> (true/false) -u <user_exp> (true/false)"
  exit 1
fi

filename=$(basename ${FILENAME})
basenm="${filename%.*}"
final_fn="${basenm}_scored_output"

BASHDIR="${USERDIR}/bashscripts/"
SRCDIR="${USERDIR}/src/"
DATADIR="${USERDIR}/data/"
OUT="${TMPDIR}/icerfire/${JOBID}/"

KERNDIST="${USERDIR}/bin/pep_kernel_dist"


# Replace PYTHON a path to your installation of python3 
# if env variable is given, otherwise just python3
if [[ "${ICERFIRE_PYTHON}" == "" ]]; then
    PYTHON="python3"
else
    #PYTHON="/home/ctools/opt/anaconda3_202105/bin/python3"
    PYTHON="${ICERFIRE_PYTHON}"
fi

mkdir -p ${OUT}
chmod 755 $OUT
# Go to the bashdir and run the bash commands
echo ${BASHDIR}
echo "netmhcpan_pipeline.sh ${FILENAME} ${OUT} ${NETMHCPAN} ${KERNDIST}"
cd ${BASHDIR}
bash netmhcpan_pipeline.sh ${FILENAME} ${OUT} ${NETMHCPAN} ${KERNDIST}

echo ${OUT}

case "$ADD_EXPR-$USER_EXPR" in
  "true-true")
    echo "User-provided expression values; Skipping PepX query"
#    echo 'total_gene_tpm' > "${OUT}${final_fn}_tmp_expr.txt"
#    awk -F ',' '{print $4}' "${FILENAME}" >> "${OUT}${final_fn}_tmp_expr.txt"
#    paste -d ' ' "${OUT}${final_fn}.txt" "${OUT}${final_fn}_tmp_expr.txt" > "${OUT}${final_fn}_tmp_merged.txt" && mv "${OUT}${final_fn}_tmp_merged.txt" "${OUT}${final_fn}.txt"
#    ;;

    if awk -F ',' 'NF>=4 && $4 + 0 == $4 {found=1; exit 0}  END {exit found ? 0 : 1}' "$FILENAME"; then
        echo 'total_gene_tpm' > "${OUT}${final_fn}_tmp_expr.txt"
        awk -F ',' '{print $4}' "${FILENAME}" >> "${OUT}${final_fn}_tmp_expr.txt"
        paste -d ' ' "${OUT}${final_fn}.txt" "${OUT}${final_fn}_tmp_expr.txt" > "${OUT}${final_fn}_tmp_merged.txt" && mv "${OUT}${final_fn}_tmp_merged.txt" "${OUT}${final_fn}.txt"
    else
        echo "User-provided expression was selected but no fourth column found. Running expression database query"
        echo " "
        bash query_pepx.sh "${OUT}${final_fn}_wt_icore.txt" ${OUT}
        PF="${OUT}${final_fn}_wt_icore_pepx_output.csv"
    fi
    ;;

  "true-false")
    echo " "
    echo "#######################"
    echo "Processing PepX score"
    echo "#######################"
    bash query_pepx.sh "${OUT}${final_fn}_wt_icore.txt" ${OUT}
    PF="${OUT}${final_fn}_wt_icore_pepx_output.csv"
    echo "pepx done"
    ;;

  "false-false")
    echo "No expression added; Skipping PepX query"
    PF="None"
    ;;

  "false-true")
    echo "Warning: Invalid combination - ADD_EXPR is 'false' but USER_EXPR is 'true'. Ignoring this part and continuing with the rest of the code."
    ;;

  *)
    echo "Invalid combination of flags: ADD_EXPR=$ADD_EXPR, USER_EXPR=$USER_EXPR"
    exit 1
    ;;
esac
echo "PYTHON: $PYTHON"
# Go to the Python dir and run the final model script
echo ${SRCDIR}
cd ${SRCDIR}
#echo "HERE IS THE PF FILE $PF"
#echo " "
#echo "#######################"
#echo "     Running Model"
#echo "#######################"
chmod 755 "${USERDIR}/src/"
echo "run python run_model"
if [[ "${ICERFIRE_PYTHON_MODULE}" != "" ]]; then
    module unload python
    module load ${ICERFIRE_PYTHON_MODULE}
fi
if [[ "${ICERFIRE_LD_LIBRARY_PATH}" != "" ]]; then
    export LD_LIBRARY_PATH=$ICERFIRE_LD_LIBRARY_PATH:$LD_LIBRARY_PATH
fi
${PYTHON} run_model.py -j ${JOBID} -f "${OUT}${final_fn}.txt" -pf "$PF" -ae "$ADD_EXPR" -tmp "${OUT}" -ue "$USER_EXPR"

