import sys
import unittest
from pathlib import Path
PROJECT_DIR = str(Path(__file__).resolve().parents[1])
sys.path.insert(1, PROJECT_DIR)
from allele_validator import AlleleValidator

class TestMROID2MethodLabel(unittest.TestCase):
    validator = AlleleValidator()

    def test_positive_cases(self):        
        '''True Case: Simple + Input/Return type agreement'''
        mroid = 'MRO:0036894'
        result = self.validator.convert_mroid_to_methodlabel(mroid)
        expected_result = 'BoLA-2:02601'
        self.assertEqual(expected_result, result)

        mroid = 'MRO:0001349'
        result = self.validator.convert_mroid_to_methodlabel(mroid)
        expected_result = 'DRB5*02:02'
        self.assertEqual(expected_result, result)

        mroid = ['MRO:0001349']
        result = self.validator.convert_mroid_to_methodlabel(mroid)
        expected_result = ['DRB5*02:02']
        self.assertEqual(expected_result, result)

    def test_negative_cases(self):
        mroid = 'MRO:1135734'
        result = self.validator.convert_mroid_to_methodlabel(mroid)
        expected_result = None
        self.assertEqual(expected_result, result)

        mroid = ['MRO:1135734']
        result = self.validator.convert_mroid_to_methodlabel(mroid)
        expected_result = [None]
        self.assertEqual(expected_result, result)

    def test_multiple_input_positive_cases(self):
        mroids = ['MRO:0036894', 'MRO:0001349', 'MRO:0000978', 'MRO:0041541']
        result = self.validator.convert_mroid_to_methodlabel(mroids)
        expected_result = ['BoLA-2:02601', 'DRB5*02:02', 'H2-IAq', 'DPA1*01:07/DPB1*29:01']
        self.assertEqual(expected_result, result)

    def test_multiple_input_negative_cases(self):
        mroids = ['MRO:1135734', 'MRO:0000938']
        result = self.validator.convert_mroid_to_methodlabel(mroids)
        expected_result = [None, None]
        self.assertEqual(expected_result, result)

        mroids = ['MRO:1135734', 'MRO:0000938', 'MRO:0041523']
        result = self.validator.convert_mroid_to_methodlabel(mroids)
        expected_result = [None, None,  'DPA1*01:07/DPB1*132:01']
        self.assertEqual(expected_result, result)

if __name__ == "__main__":
    unittest.main()