import pandas as pd
import os
import sys
from pathlib import Path
from netmhcpan_4_1_executable import predict_many_peptides_file

def main():
    NETMHCPAN_ALLELES_FILE = 'master_netmhcpan_4_1_alleles.tsv'
    alleles_df = pd.read_csv(NETMHCPAN_ALLELES_FILE, sep='\t', index_col=False)
    header = list(alleles_df.columns)
    print(header)

    invalid_tool_labels = []
    counter = 1
    for row in alleles_df.itertuples():
        # Retrieve tool label
        tool_label_col = header.index('Tool Label') + 1
        attribute_idx = f'_{tool_label_col}'
        tool_label = getattr(row, attribute_idx)
        print(tool_label)
        
        # result = predict_many_peptides_file('test_seqs.pep', ['HLA-A01:01'])
        result = predict_many_peptides_file('test_seqs.pep', [tool_label])
        print(result, f'{counter}/{len(alleles_df)}')

        counter = counter + 1

        if not result:
            invalid_tool_labels.append(row)
    
    print('----------------')
    print(invalid_tool_labels)
    print(len(invalid_tool_labels))

    # result = predict_many_peptides_file('test_seqs.pep', ['Mamu-AG*02011'])
    # result = predict_many_peptides_file('test_seqs.pep', ['HLA-A01:01'])

    print(result)

if __name__=='__main__':
    main()