import sys
import time
import pandas as pd
from pathlib import Path
from tqdm import tqdm

# ===============================================================================================
# Global Vars.
# ===============================================================================================
DATA_DIR = Path(__file__).parent.parent / "data"
TOOLS_MAPPING_FILE = DATA_DIR / 'tools-mapping.tsv'
LENGTH_TABLE_PATH = DATA_DIR / 'allele-lengths.xlsx'


def update_icerfire_lengths():
    xls = pd.read_excel(LENGTH_TABLE_PATH, sheet_name="all methods", engine='openpyxl')
    icerfire_row = xls.iloc[-1]
    # need to remove the brackets {' and '}
    length = icerfire_row.lengths[2:-2]
    tm_df = pd.read_csv(TOOLS_MAPPING_FILE, sep='\t')
    
    tm_df.loc[tm_df['Tool'] == 'icerfire', 'Lengths'] = length

    tm_df.to_csv(TOOLS_MAPPING_FILE, sep='\t', index=False)
    
    
if __name__=='__main__':
    # 11/21/24 - Update length
    update_icerfire_lengths()
