import unittest
import pandas as pd
import os
from pathlib import Path
from netmhcpan_4_1_executable import predict_many_peptides_file
SKIP_NETMHCPAN_CI = eval(os.getenv('SKIP_NETMHCPAN_CI', "False"))

@unittest.skipIf(SKIP_NETMHCPAN_CI, "CI Can't seem to find location of netmhcpan_4_1_executable")
class NetMHCpan41ExecutableTest(unittest.TestCase):
    NUM_SAMPLES = 50
    PROJECT_DIR = str(Path(__file__).parent.parent)
    DATA_DIR = PROJECT_DIR + '/data'
    TEST_DIR = PROJECT_DIR + '/tests'

    '''test cases for netmhcpan 4.0 and netmhcpan_el 4.0'''
    def test_base_case(self):
        TM_FILE = self.DATA_DIR + '/tools-mapping.tsv'
        SEQUENCE_FILE = self.TEST_DIR + '/data/seqs.pep'

        tm_df = pd.read_csv(TM_FILE, sep='\t', index_col=False)
        alleles_df = tm_df[tm_df['Tool']=='netmhcpan']

        # Randomly select 50 rows from the dataframe
        random_sample_df = alleles_df.sample(n=self.NUM_SAMPLES)

        for row in random_sample_df.itertuples():
            # Columns: Tool Group, Tool, Tool Version, Tool Label, MRO ID, Lengths
            tool_label = row._4
            result = predict_many_peptides_file(SEQUENCE_FILE, [tool_label])
            if not result:
                raise ValueError(f"Tool Label ({tool_label}) is not compatible with netmhcpan-4.1 method.")

if __name__=='__main__':
    unittest.main()