import pandas as pd
from pathlib import Path
from tqdm import tqdm
from allele_validator import AlleleValidator

def main():
    # Get allele data
    PARENT_DIR = Path(__file__).parent
    DATA_DIR = str(PARENT_DIR.parent) + "/data"
    ICERFIRE_DATA = DATA_DIR + "/icerfire-1.0/hla_list.txt"

    with open(ICERFIRE_DATA, 'r') as f:
        icer_alleles = [_.strip() for _ in f.readlines()]
    
    av = AlleleValidator()
    df = av.data['mro_data']

    # First round of identification
    for allele in tqdm(icer_alleles):
        iedb_label = av._convert_methodlabel_to_iedblabel(method_label=allele)
        mroid = av._convert_methodlabel_to_mroid(method_label=allele)
        
        # Second round of identification
        if not iedb_label:
            mroid, tool_label, iedb_label = av._identify_unknown_allele(allele)
        
        # Add icerfire row to the dataframe
        row = ['pvc', 'icerfire', '1.0', allele, iedb_label, mroid, '8,9,10,11,12']
        df = pd.concat([df, pd.DataFrame([row], columns=df.columns)], ignore_index=True)
        
    df.to_csv(f'{DATA_DIR}/tools-mapping.tsv', sep='\t', index=False)


if __name__=='__main__':
    main()