import sys
import unittest
from pathlib import Path
PROJECT_DIR = str(Path(__file__).resolve().parents[1])
sys.path.insert(1, PROJECT_DIR)
from allele_validator import AlleleValidator

class TestSynonym2IEDBLabel(unittest.TestCase):
    validator = AlleleValidator()

    def test_positive_cases(self):        
        '''True Case: Simple + Input/Return type agreement'''
        synonym = 'HLA-A11:175'
        result = self.validator.convert_synonym_to_iedblabel(synonym)
        expected_result = 'HLA-A*11:175'
        self.assertEqual(expected_result, result)

        synonym = 'HLA-DPw9'
        result = self.validator.convert_synonym_to_iedblabel(synonym)
        expected_result = 'HLA-DPA1*02:01/DPB1*09:01'
        self.assertEqual(expected_result, result)

        synonym = ['HLA-DPw9']
        result = self.validator.convert_synonym_to_iedblabel(synonym)
        expected_result = ['HLA-DPA1*02:01/DPB1*09:01']
        self.assertEqual(expected_result, result)

    def test_negative_cases(self):
        iedb_label = 'HLA-C*03:214'
        result = self.validator.convert_synonym_to_iedblabel(iedb_label)
        # expected_result = 'HLA-C*03:214'
        self.assertIsNone(result)

        iedb_label = ['HLA-C*03:214']
        result = self.validator.convert_synonym_to_iedblabel(iedb_label)
        # expected_result = ['HLA-C*03:214']
        # self.assertEqual(expected_result, result)
        self.assertIsNone(result[0])

    def test_multiple_input_positive_cases(self):
        synonyms = ['BoLA-2:02601', 'DRB5*02:02', 'H-2-Kb', 'DPA1*01:07/DPB1*29:01']
        result = self.validator.convert_synonym_to_iedblabel(synonyms)
        expected_result = ['BoLA-2*026:01', 'HLA-DRB5*02:02', 'H2-Kb', 'HLA-DPA1*01:07/DPB1*29:01']
        self.assertEqual(expected_result, result)


    def test_multiple_input_negative_cases(self):
        synonyms = ['BoLA-2*069:01', 'BoLA-DQA*010:01:01/DQB*010:02:01', 'DRB*13:11']
        result = self.validator.convert_synonym_to_iedblabel(synonyms)
        # expected_result = ['BoLA-2*069:01', 'BoLA-DQA*010:01:01/DQB*010:02:01', 'DRB*13:11']
        expected_result = [None, None, None]
        self.assertEqual(expected_result, result)

        synonyms = ['BoLA-2*069:01', 'BoLA-DQA*010:01:01/DQB*010:02:01', 'DPA1*01:07/DPB1*132:01']
        result = self.validator.convert_synonym_to_iedblabel(synonyms)
        # expected_result = ['BoLA-2*069:01', 'BoLA-DQA*010:01:01/DQB*010:02:01', 'HLA-DPA1*01:07/DPB1*132:01']
        expected_result = [None, None, 'HLA-DPA1*01:07/DPB1*132:01']

        self.assertEqual(expected_result, result)

if __name__ == "__main__":
    unittest.main()