# NXG API Client

This package contains code for interacting with the Nextgen Tools API, including
functions for:
* pulling down pipeline stage information
* pulling down stage input data
* pulling down any object (e.g., results, input_parameters, etc.)
* posting results back to the database
* posting job IDs back to the database
* converting between api & command line input formats

## Usage

The NXGClient class can be instantiated with:

```python
a = NXGclient(base_uri='https://api-nextgen-tools-dev.iedb.org/api/v1')
```

If no ```base_uri``` parameter is provided, the production site will be used.

An example is describe below.  Have a look at the docstrings to understand
the rest of the functions, which should be mostly self-explanatory.

### Example

The ```main``` function illustrates most of the functionality in this package:

```python
def main():
    pipeline_id = 'edb2cf7e-6883-4015-8fb1-e6f84f98a54f'
    a = NXGclient(base_uri='https://api-nextgen-tools-dev.iedb.org/api/v1')
    pipeline_json = a.get_pipeline(pipeline_id)
    print(pipeline_json['pipeline_date'])
    stage_list = a.get_pipeline_stages(pipeline_id)
    for sid in stage_list:
        stage_inputs = a.get_stage_inputs(sid)
        cmd_inputs = api2cmd_input_mhci(stage_inputs)
```

Given a pipeline_id, the ```get_pipeline``` function hits the /pipeline endpoint
to retrieve the pipeline description as JSON.

The list of stage IDs is retrieved with the ```get_pipeline_stages``` function.

Iterating through the stage id list, the inputs for each stage are retrieved
with the ```get_stage_inputs``` function.  This will return a dictionary
consisting of:

* ```input_parameters```: The prediction parameters for the given stage.
* ```input_datasets``` or ```piped_datasets```: If this is a downstream stage
that has had data piped to it, it will be included here.
* ```input_sequence_fasta_uri```: If this stage received an input sequence, the
URI to retrieve it in fasta format is here.

Finally, the input for the stage is converted from API format into the format
required for the command line tool.

### Caching

By default, the client will only retrieve the pipeline and stage information
from the API once per session.  If the pipeline or stage information was already
retrieved during the client's runtime, the cached version of that data will be
used.  This can be overridden in several of the functions by calling them with
```use_cache=False```.  The only time this should be set to false is if data
on the server is expected to change between API calls.