#!/usr/bin/env python3

# Code to generate a slurm API token
# Adapted from
# https://slurm.schedmd.com/jwt.html

import sys
import os
import pprint
import json
import time
from datetime import datetime, timedelta, timezone

from jwt import JWT
from jwt.jwa import HS256
from jwt.jwk import jwk_from_dict
from jwt.utils import b64decode,b64encode


def get_slurm_token(
    priv_key_file=None,
    user='nxg-api',
    expiration_seconds=2592000
    ):
    """Given a private key file, username, and expiration time (in seconds)
    getnerate a JWT token for use with the SLURM API"""

    with open(priv_key_file, "rb") as f:
        priv_key = f.read()

    signing_key = jwk_from_dict({
        'kty': 'oct',
        'k': b64encode(priv_key)
    })

    message = {
        "exp": int(time.time() + int(expiration_seconds)),
        "iat": int(time.time()),
        "sun": user
    }

    a = JWT()
    compact_jws = a.encode(message, signing_key, alg='HS256')

    return compact_jws


def main():

    if len(sys.argv) != 4:
        sys.exit("gen_jwt.py [private_key_file] [user name] [expiration time (seconds)]");

    priv_key_file=sys.argv[1]
    user=sys.argv[2]
    expiration_seconds=sys.argv[3]

    t = get_slurm_token(priv_key_file,
                    user,
                    expiration_seconds)

    print(t)


if __name__ == "__main__":
    main()

