import textwrap
import argparse
import validators
import os
import sys
from NGArgumentParser import NGArgumentParser


class PhbrArgumentParser(NGArgumentParser):
    def __init__(self):
        super().__init__()

        # ADD program details by setting params, such as
        # prog, usage, description, epilog, etc.
        # -----------------------------------------------------
        self.description = textwrap.dedent(
            '''
            Compute PHBR score for each peptide.
            '''
        )

        # ADD subparser prediction descriptions
        # -----------------------------------------------------
        pred_parser = self.add_predict_subparser(
            help='Compute PHBR score for each peptide.',
            description='Compute PHBR score for each peptide.'
        )

        # ADD tool-specific params 
        # -----------------------------------------------------
        # pred_parser.add_argument("--input-tsv", "-t",
        #                         dest="input_tsv",
        #                         type=argparse.FileType('r'),
        #                         default=None,
        #                         help="Perform counting given a TSV file.",
        #                         )
        pred_parser.add_argument("--input-json", "-j",
                                dest="input_json",
                                type=argparse.FileType('r'),
                                default=None,
                                help="Perform counting given a JSON file.",
                                )
        pred_parser.add_argument("--output-prefix", "-o",
                                dest="output_prefix",
                                help="prediction result output prefix.",
                                metavar="OUTPUT_PREFIX")
        pred_parser.add_argument("--output-format", "-f",
                                dest="output_format",
                                default="tsv",
                                help="prediction result output format (Default=tsv)",
                                metavar="OUTPUT_FORMAT")
        pred_parser.add_argument("--output-dir", "-d",
                        dest="output_dir",
                        default="/tmp",
                        help="prediction result output directory (Default=/tmp)",
                        metavar="OUTPUT_DIR")
        # a flag to indicate whether or not to include the mhci & mhcii result (peptide table)
        self.parser_preprocess.add_argument("--include-mhci-mhcii-result",
                                        action="store_true",
                                        dest="include_mhci_mhcii_result",
                                        default=False,
                                        help="flag to indicate whether or not to include mhci & mhcii result (peptide table) in the job description file")
        # a flag to indicate whether or not to include the mhci & mhcii result (peptide table)
        self.parser_postprocess.add_argument("--include-mhci-mhcii-result",
                                action="store_true",
                                dest="include_mhci_mhcii_result",
                                default=False,
                                help="flag to indicate whether or not to include mhci & mhcii result (peptide table) in the post-processed result")
