import json
import subprocess
import sys
from pathlib import Path
import shlex


def run_jobs(job_descriptions_file: str) -> None:
    """
    Run jobs from job_descriptions.json file sequentially.
    
    Args:
        job_descriptions_file: Path to the job descriptions JSON file
    """
    # Read the job descriptions file
    with open(job_descriptions_file, 'r') as f:
        jobs = json.load(f)
    
    # Track completed jobs
    completed_jobs = set()
    
    # Run jobs sequentially
    for job in jobs:
        job_id = job['job_id']
        depends_on = job.get('depends_on_job_ids', [])
        
        # # Check if all dependencies are completed
        # if not all(dep_id in completed_jobs for dep_id in depends_on):
        #     print(f"Skipping job {job_id}: dependencies not met")
        #     continue
        

        # Split the command into a list for subprocess
        cmd = shlex.split(job['shell_cmd'])

        # print(cmd)

        if 'tcell_mhci.py' in cmd[0]:
            activate_env = 'source /home/hkim/NGIEDB/cli/phbr/build/ng_phbr-local/setup_tcell_class_i_env.sh && python '
        elif 'tcell_mhcii.py' in cmd[0]:
            activate_env = 'source /home/hkim/NGIEDB/cli/phbr/build/ng_phbr-local/setup_tcell_class_ii_env.sh && python '
        else:
            activate_env = 'python '

        cmd = activate_env + ' '.join(cmd)

        print(f"Running job {job_id}: \n{cmd}\n")
        

def main():
    if len(sys.argv) != 2:
        print("Usage: python jd_runner.py <job_descriptions_file>")
        sys.exit(1)
    
    job_descriptions_file = sys.argv[1]
    if not Path(job_descriptions_file).exists():
        print(f"Error: File {job_descriptions_file} does not exist")
        sys.exit(1)
    
    run_jobs(job_descriptions_file)


if __name__ == '__main__':
    main() 