#!/bin/bash

#################################################################################################################
# Pull down latest molecule_export.tsv and save it as mro_molecules.tsv
#################################################################################################################
BASE_URL="https://api.github.com/repos/IEDB/MRO/releases/latest"

# Extracting out URL to the IEDB zip file
MRO_URL=$(curl -H "Accept: application/vnd.github.v3+json" -s $BASE_URL | \
        python3 -c "import sys, json; data=json.load(sys.stdin); print(data['assets'][0]['browser_download_url'])")

# Download & extract only the molecule_export.tsv file
curl -L -o iedb.zip $MRO_URL 
unzip -p iedb.zip molecule_export.tsv > ./data/_mro_molecules.tsv

if diff "./data/mro_molecules.tsv" "./data/_mro_molecules.tsv" > /dev/null; then
        # If parameter is not provided OR if the parameter is not equal to 1, then terminate.
        # Otherwise, it should proceed with updating the files (use-case is for testing locally)
        if [ -z "$1" ] || [ "$1" -ne 1 ]; then
                echo "The new MRO Molecules TSV file is identical to the previous one. No update needed."
                rm ./data/_mro_molecules.tsv

                echo "Removed the new MRO Molecules TSV file."
                exit 1
        fi
fi
echo "The TSV files are different. Now pulling the latest MRO molecules file."

# Replace the molecules file with the new one
mv ./data/_mro_molecules.tsv ./data/mro_molecules.tsv

# TODO: Create report on what's new.

# Run the update script
python update_allele_files_2.py

# Pickle the data
python generate_pickle_data.py

rm -rf iedb.zip