'''
Created on Oct 2, 2019
@author: Yan
The code coverage by tests is 100%. (__init__.py)  
'''
from unittest import TestCase
import unittest

from mhci_ann_predictor_percentile_data import score_distributions
'''
Name                                                                                                        Stmts   Miss  Cover
-------------------------------------------------------------------------------------------------------------------------------
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/pkg_resources/__init__.py                         1607    988    39%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/pkg_resources/_vendor/__init__.py                    0      0   100%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/pkg_resources/_vendor/packaging/__about__.py        10      0   100%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/pkg_resources/_vendor/packaging/__init__.py          3      0   100%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/pkg_resources/_vendor/packaging/_compat.py          12      1    92%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/pkg_resources/_vendor/packaging/_structures.py      41     17    59%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/pkg_resources/_vendor/packaging/specifiers.py      281    201    28%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/pkg_resources/_vendor/packaging/version.py         150     78    48%
mhci_ann_predictor_percentile_data/__init__.py                                                                 13      0   100%
tests.py                                                                                                       25      0   100%
-------------------------------------------------------------------------------------------------------------------------------
TOTAL                                                                                                        2142   1285    40%
'''
class GetModleDataTests(TestCase):

    def test_H2(self):
        distribution = score_distributions[('ann', 'H-2-Db', 9)]
        expected_distribution = [6.34, 12.97, 33.76, 48.92, 71.01, 82.49, 92.51, 107.03, 114.29, 138.8, 163.5, 179.57, 195.59, 217.82, 228.57, 259.05, 279.84, 302.65, 316.68, 341.11, 360.51, 368.96, 380.76, 398.97, 424.84, 452.02, 467.64, 496.33, 514.76, 546.05, 609.09, 636.85, 683.91, 723.61, 753.06, 778.47, 808.13, 835.72, 858.08, 886.2, 897.71, 921.12, 939.45, 957.97, 974.13, 994.47, 1024.08, 1046.94, 1071.51, 1097.04, 1128.15, 1145.26, 1168.99, 1180.55, 1210.59, 1241.41, 1292.53, 1327.67, 1362.44, 1381.83, 1450.93, 1462.92, 1475.08, 1525.66, 1561.25, 1575.47, 1630.99, 1661.5, 1697.06, 1715.02, 1751.74, 1798.27, 1818.81, 1856.41, 1894.13, 1939.74, 1955.96, 1973.97, 1997.58, 2027.13, 2050.96, 2087.02, 2123.88, 2165.04, 2194.35, 2225.75, 2244.68, 2273.43, 2310.23, 2347.06, 2369.77, 2392.08, 2425.39, 2465.71, 2506.19, 2535.9, 2569.87, 2591.06, 2609.38, 2639.99, 2655.2, 2980.19, 3267.91, 3590.55, 3921.59, 4269.45, 4638.28, 4913.0, 5216.72, 5520.91, 5925.73, 6165.3, 6409.7, 6700.37, 6984.77, 7279.2, 7591.86, 7833.6, 8105.36, 8322.56, 8610.07, 8815.76, 9059.93, 9331.13, 9577.96, 9839.08, 10078.17, 10291.39, 10547.97, 10785.25, 11041.34, 11283.73, 11510.5, 11783.95, 11979.75, 12185.38, 12409.44, 12642.81, 12850.24, 13065.57, 13243.91, 13425.85, 13646.7, 13805.91, 14021.64, 14218.56, 14403.28, 14588.2, 14779.32, 14951.75, 15127.0, 15321.53, 15496.92, 15657.87, 15840.03, 15994.69, 16154.17, 16339.99, 16509.52, 16669.99, 16879.25, 17030.23, 17205.99, 17356.13, 17482.03, 17706.28, 17902.0, 18053.14, 18206.14, 18383.69, 18576.85, 18722.74, 18883.25, 19010.56, 19162.96, 19332.9, 19476.51, 19617.15, 19770.15, 19936.84, 20125.61, 20245.52, 20382.45, 20518.3, 20661.1, 20794.54, 20940.4, 21048.06, 21184.23, 21321.51, 21449.01, 22656.28, 23878.75, 25029.5, 26014.65, 26947.47, 27878.4, 28785.08, 29647.06, 30453.67, 31172.44, 31853.31, 32493.46, 33078.77, 33646.56, 34227.8, 34768.29, 35305.83, 35834.23, 36322.96, 36786.5, 37238.63, 37674.28, 38056.1, 38435.99, 38799.93, 39150.36, 39488.58, 39803.86, 40124.71, 40415.32, 40701.44, 40976.27, 41269.05, 41523.45, 41800.21, 42047.9, 42310.29, 42554.08, 42785.4, 43024.46, 43244.75, 43461.94, 43669.79, 43867.27, 44058.5, 44243.38, 44426.59, 44601.91, 44766.78, 44922.05, 45084.7, 45234.21, 45388.16, 45538.65, 45682.76, 45824.36, 45964.89, 46098.36, 46223.72, 46341.89, 46472.44, 46597.31, 46705.83, 46827.8, 46938.37, 47047.68, 47155.73, 47258.91, 47362.31, 47461.84, 47556.42, 47651.68, 47748.74, 47838.18, 47927.83, 48016.56, 48102.88, 48184.66, 48267.11, 48350.76, 48431.9, 48517.93, 48600.92, 48685.65, 48771.07, 48859.28, 48956.11, 49055.82, 49172.73]
        self.assertEqual(distribution, expected_distribution)

    def test_HLA(self):
        distribution = score_distributions[('ann', 'HLA-A02:01', 9)]
        expected_distribution = [2.54, 5.14, 5.95, 6.71, 7.32, 8.39, 9.25, 9.94, 11.05, 12.5, 13.3, 14.13, 14.78, 15.61, 16.25, 17.52, 18.77, 19.82, 21.34, 23.21, 24.09, 25.59, 26.56, 27.41, 28.31, 29.58, 30.7, 31.72, 33.07, 33.88, 35.33, 36.38, 37.47, 38.4, 39.56, 41.1, 42.08, 42.83, 44.13, 45.45, 46.18, 47.02, 47.97, 48.88, 49.95, 50.94, 52.63, 53.99, 54.64, 55.48, 57.2, 58.96, 60.33, 61.44, 62.8, 63.16, 63.92, 64.89, 65.65, 66.78, 67.71, 68.73, 69.7, 70.67, 71.35, 72.39, 73.7, 76.18, 77.83, 78.7, 80.29, 80.66, 81.31, 83.36, 84.24, 85.89, 88.07, 89.72, 91.07, 92.26, 93.44, 96.34, 98.65, 100.55, 101.66, 103.23, 106.44, 108.0, 109.58, 110.74, 113.1, 114.38, 116.71, 118.26, 120.02, 121.53, 122.66, 124.9, 125.81, 127.33, 129.04, 146.75, 163.81, 182.3, 201.66, 220.09, 235.47, 256.19, 273.63, 300.12, 321.81, 345.76, 365.24, 394.75, 423.57, 453.75, 480.72, 514.72, 541.52, 575.04, 606.74, 643.19, 681.04, 717.11, 758.21, 786.33, 821.05, 857.66, 892.38, 930.39, 968.23, 998.2, 1036.26, 1079.2, 1123.64, 1164.95, 1212.08, 1260.32, 1298.8, 1342.25, 1378.73, 1432.44, 1476.85, 1524.51, 1573.75, 1630.72, 1677.3, 1721.8, 1765.67, 1817.12, 1873.56, 1916.58, 1959.33, 2015.17, 2064.02, 2116.44, 2167.26, 2226.86, 2275.72, 2327.76, 2392.86, 2446.07, 2510.15, 2564.56, 2622.51, 2693.19, 2748.89, 2810.76, 2876.66, 2942.39, 3005.19, 3060.28, 3118.11, 3164.4, 3215.96, 3276.06, 3332.32, 3382.45, 3455.36, 3524.16, 3590.43, 3657.24, 3720.86, 3781.75, 3852.91, 3919.55, 3997.03, 4061.9, 4128.45, 4205.36, 4270.06, 5001.12, 5727.17, 6426.16, 7154.65, 7891.53, 8649.85, 9409.5, 10200.37, 10947.01, 11654.74, 12386.23, 13104.79, 13838.07, 14565.64, 15249.58, 15892.74, 16603.21, 17253.35, 17887.86, 18536.29, 19153.63, 19761.59, 20365.25, 20916.39, 21500.13, 22073.38, 22636.19, 23172.44, 23692.17, 24184.26, 24680.43, 25161.19, 25615.51, 26074.39, 26538.04, 26969.93, 27408.53, 27799.78, 28180.16, 28589.84, 28964.72, 29333.41, 29710.32, 30061.48, 30433.59, 30773.31, 31130.63, 31462.83, 31814.04, 32138.23, 32451.65, 32764.59, 33103.1, 33408.24, 33718.35, 34041.3, 34336.49, 34631.62, 34937.61, 35228.75, 35512.33, 35782.32, 36072.31, 36344.58, 36624.06, 36919.28, 37206.01, 37492.11, 37759.17, 38034.7, 38298.98, 38598.52, 38881.03, 39174.51, 39455.69, 39746.19, 40048.37, 40365.48, 40686.46, 41015.32, 41362.47, 41742.81, 42110.72, 42532.0, 42984.45, 43467.09, 44017.04, 44644.42, 45378.32] 
        self.assertEqual(distribution, expected_distribution)

    def test_Mamu(self):
        distribution = score_distributions[('ann', 'Mamu-A2201', 9)]
        expected_distribution = [4.15, 6.21, 6.82, 8.21, 9.43, 10.27, 11.2, 12.51, 14.02, 14.69, 16.55, 17.61, 19.49, 21.41, 23.47, 23.98, 25.31, 26.63, 28.02, 29.51, 31.19, 32.81, 34.02, 36.0, 37.41, 39.59, 42.46, 44.51, 46.64, 49.51, 51.92, 54.16, 56.26, 58.12, 60.22, 61.82, 64.4, 66.77, 68.03, 72.68, 75.56, 77.81, 79.87, 81.77, 84.19, 87.21, 89.59, 94.35, 99.31, 101.28, 107.02, 108.2, 112.88, 115.52, 117.91, 123.46, 126.26, 130.48, 135.06, 137.33, 141.24, 145.36, 150.47, 156.52, 161.51, 164.27, 167.66, 171.52, 173.53, 179.85, 184.75, 188.0, 195.59, 202.89, 208.47, 215.49, 218.32, 223.7, 228.75, 232.62, 239.73, 245.93, 249.57, 252.66, 257.39, 261.38, 264.86, 270.18, 276.39, 281.48, 286.69, 289.59, 293.12, 299.84, 305.27, 310.97, 318.89, 328.72, 334.5, 337.91, 343.93, 399.01, 469.12, 553.36, 630.69, 724.62, 815.57, 919.3, 1023.65, 1132.77, 1244.66, 1352.64, 1468.66, 1588.11, 1724.23, 1834.23, 1971.49, 2108.12, 2236.59, 2376.88, 2493.56, 2611.01, 2755.5, 2899.53, 3035.42, 3220.77, 3413.22, 3558.79, 3733.97, 3934.59, 4106.66, 4275.93, 4465.05, 4670.77, 4843.06, 5037.94, 5236.91, 5403.19, 5592.64, 5747.72, 5935.74, 6146.25, 6310.54, 6499.58, 6694.79, 6856.21, 7009.68, 7165.19, 7363.56, 7559.32, 7742.09, 7914.53, 8074.12, 8279.89, 8508.85, 8710.9, 8911.38, 9052.97, 9264.23, 9451.85, 9659.96, 9822.91, 10053.34, 10235.42, 10439.54, 10612.88, 10811.3, 11050.07, 11217.15, 11403.27, 11531.2, 11702.0, 11881.38, 12076.7, 12251.08, 12449.64, 12615.48, 12792.38, 12985.95, 13167.47, 13330.03, 13499.26, 13691.52, 13882.91, 14043.05, 14244.9, 14435.12, 14607.62, 14789.08, 14989.97, 15168.3, 16837.85, 18426.71, 19945.03, 21439.5, 22822.61, 24101.46, 25373.05, 26486.98, 27601.38, 28681.25, 29673.38, 30636.77, 31513.92, 32309.05, 33004.77, 33701.94, 34373.29, 35029.59, 35635.88, 36197.41, 36758.25, 37255.95, 37738.74, 38210.84, 38675.86, 39075.45, 39474.9, 39832.72, 40195.08, 40531.36, 40862.06, 41161.11, 41480.78, 41758.18, 42019.25, 42282.38, 42535.2, 42774.28, 43002.13, 43235.86, 43456.28, 43672.16, 43873.43, 44075.18, 44272.09, 44450.18, 44631.38, 44800.71, 44970.69, 45130.07, 45284.16, 45429.42, 45577.61, 45716.89, 45852.62, 45994.72, 46123.82, 46245.73, 46365.98, 46485.03, 46603.86, 46715.44, 46822.21, 46925.69, 47030.39, 47134.82, 47232.83, 47337.21, 47433.59, 47531.71, 47621.79, 47710.51, 47797.82, 47888.41, 47973.47, 48058.16, 48142.98, 48222.74, 48307.34, 48388.44, 48469.64, 48554.15, 48629.86, 48713.07, 48799.57, 48882.54, 48974.14, 49072.78, 49201.98]
        self.assertEqual(distribution, expected_distribution)

    def test_SLA(self):
        distribution = score_distributions[('ann', 'SLA-10401', 9)]
        expected_distribution = [7.08, 39.58, 59.78, 77.42, 102.85, 116.92, 129.08, 138.6, 148.71, 168.79, 183.66, 201.54, 224.81, 255.28, 270.21, 292.53, 308.75, 347.9, 362.88, 371.74, 391.8, 421.1, 448.84, 464.37, 491.54, 512.78, 528.85, 546.5, 558.03, 576.28, 600.11, 632.43, 661.1, 682.91, 703.88, 726.13, 755.24, 771.01, 803.63, 843.47, 879.57, 888.77, 911.97, 931.8, 951.28, 971.93, 992.53, 1019.23, 1055.98, 1063.39, 1076.72, 1096.71, 1117.13, 1129.41, 1144.9, 1184.9, 1216.83, 1229.18, 1243.32, 1256.03, 1298.11, 1318.92, 1327.97, 1359.29, 1384.94, 1421.5, 1447.76, 1468.01, 1481.72, 1509.42, 1545.16, 1580.91, 1618.89, 1649.53, 1678.27, 1704.42, 1746.23, 1767.94, 1806.56, 1830.3, 1876.32, 1907.31, 1941.98, 1957.57, 2007.48, 2018.57, 2064.52, 2082.66, 2114.57, 2138.54, 2154.38, 2172.83, 2195.61, 2225.99, 2264.86, 2284.97, 2306.23, 2335.69, 2386.47, 2431.03, 2461.84, 2758.99, 3053.34, 3312.45, 3617.61, 3921.89, 4212.24, 4425.99, 4752.58, 5001.82, 5234.42, 5506.89, 5803.71, 6194.86, 6494.66, 6720.63, 6986.43, 7210.06, 7489.63, 7727.28, 7969.27, 8230.77, 8485.95, 8735.25, 8952.35, 9217.24, 9456.04, 9684.67, 9971.87, 10174.7, 10418.89, 10690.09, 10942.4, 11196.41, 11429.96, 11680.5, 11904.03, 12071.34, 12310.61, 12545.65, 12775.37, 13012.39, 13218.43, 13432.53, 13637.4, 13835.07, 14079.56, 14307.92, 14484.39, 14693.54, 14882.83, 15082.7, 15293.21, 15494.91, 15687.55, 15908.74, 16118.56, 16294.96, 16480.79, 16682.43, 16854.8, 16996.17, 17164.34, 17323.87, 17516.11, 17721.42, 17896.58, 18076.0, 18240.44, 18381.9, 18542.71, 18692.37, 18881.62, 19020.64, 19182.25, 19345.25, 19522.5, 19674.55, 19843.86, 19971.16, 20133.89, 20293.54, 20479.71, 20623.58, 20755.88, 20906.43, 21045.1, 21168.88, 21298.46, 21452.26, 21592.44, 23030.73, 24335.19, 25645.46, 26720.42, 27774.22, 28732.18, 29665.34, 30608.93, 31427.79, 32194.59, 32878.59, 33508.88, 34102.88, 34690.88, 35208.56, 35710.37, 36148.48, 36592.78, 37008.46, 37398.92, 37786.14, 38162.49, 38504.24, 38838.98, 39161.37, 39457.82, 39757.37, 40022.37, 40269.52, 40534.0, 40774.61, 40999.35, 41211.93, 41414.41, 41603.48, 41792.53, 41980.16, 42159.96, 42338.24, 42498.87, 42657.8, 42811.79, 42965.38, 43117.18, 43260.65, 43394.72, 43528.28, 43661.29, 43788.09, 43902.9, 44020.39, 44131.02, 44235.7, 44334.41, 44434.79, 44537.3, 44637.16, 44738.7, 44834.64, 44935.18, 45022.29, 45108.6, 45199.95, 45281.21, 45368.99, 45451.54, 45537.18, 45624.49, 45709.96, 45794.11, 45877.44, 45954.93, 46037.04, 46122.3, 46198.71, 46279.26, 46361.47, 46444.81, 46530.32, 46612.46, 46696.25, 46780.68, 46874.42, 46970.89, 47078.25, 47186.86, 47304.43, 47455.66, 47655.31]
        self.assertEqual(distribution, expected_distribution)

    def test_key_error(self):
        with self.assertRaises(KeyError):
            distribution = score_distributions[('ann', 'SLA-1*0401', 9)]


if __name__ == '__main__':
    unittest.main()
