from netchop_3_1_executable import predict as netchop_predict

def netchop_test(input_fasta_list, input_params):
    # scores is an ordered dictionary of input name(key) and tuples of prediction scores(value)
    threshold = input_params['threshold']
    method = input_params['method']
    short = input_params['short']
    
    scores = netchop_predict(input_fasta_list, threshold=threshold, method=method, short=short)
    for i, key in enumerate(scores.keys(), start=1):
        print("key {}: {}\nvalue {}: {}".format(i, key, i, scores[key]))


if __name__ == '__main__':
    """
    Optional named input parameters:
    threshold(default='0.500000'), method(default='0') and short(default=False)
    """
    input_fasta_list = [">test1\nMSLLTEVETPIRNEWGCRCN\n>test2\nDSHTVSSFQVDCFLWHVRKQVADQDLGDAPFLDRLRRDQKSLKGRG"]
    
    input_params = {
        'threshold':'0.500000', 
        'method':'0', 
        'short':False
    }
    netchop_test(input_fasta_list, input_params)