from netctlpan_1_1_executable import predict as netctlpan_predict

def netctlpan_test(input_fasta_list, input_params):
    # scores is an ordered dictionary of input name(key) and tuples of prediction scores(value)
    allele = input_params['allele']
    length = input_params['length']
    tap_weight = input_params['tap_weight']
    cleavage_weight = input_params['cleavage_weight']
    epitope_threshold = input_params['epitope_threshold']
    threshold = input_params['threshold']
    sort = input_params['sort']
    
    scores = netctlpan_predict(input_fasta_list, allele=allele, length=length, tap_weight=tap_weight, cleavage_weight=cleavage_weight, epitope_threshold=epitope_threshold, threshold=threshold, sort=sort)
    for i, key in enumerate(scores.keys(), start=1):
        print("key {}: {}\nvalue {}: {}".format(i, key, i, scores[key]))


if __name__ == '__main__':
    """
    Optional named input parameters:
    allele(default='HLA-A02:01'), length(default='9'), tap_weight(default='0.025000'), cleavage_weight(default='0.225000'),
    epitope_threshold(default='1.000000'), threshold(default='-99.900002') and sort(default='-1')
    """
    input_fasta_list = [">test1\nMSLLTEVETPIRNEWGCRCN\n>test2\nDSHTVSSFQVDCFLWHVRKQVADQDLGDAPFLDRLRRDQKSLKGRG"]
    
    input_params = {
        'allele':'HLA-A02:01', 
        'length':'9', 
        'tap_weight':'0.025000', 
        'cleavage_weight':'0.225000', 
        'epitope_threshold':'1.000000', 
        'threshold':'-99.900002', 
        'sort':'-1'
    }
    netctlpan_test(input_fasta_list, input_params)