import unittest
import sys
from pathlib import Path
PROJECT_DIR = str(Path(__file__).resolve().parents[1])
sys.path.insert(1, PROJECT_DIR)
from allele_validator import Allele_Validator


class IdentifyAllele(unittest.TestCase):
    def test_basic(self):
        validator = Allele_Validator()

        # IEDB Label
        allele = "BoLA-1*023:01"
        label = validator.identify_label(allele, "netmhcpan")
        self.assertEqual("iedb_label", label)

        # Tool Label
        allele = "SLA-2:1002"
        label = validator.identify_label(allele, "netmhcpan")
        self.assertEqual("tool_label", label)

        # Synonym
        allele = "Qa1a"
        label = validator.identify_label(allele, "netmhcpan")
        self.assertEqual("synonym", label)



if __name__=='__main__':
    unittest.main()