'''
Created on Oct 9, 2019
@author: Yan
The code coverage by tests is 100%. (__init__.py)  
'''
from unittest import TestCase
import unittest

from mhci_comblib_sidney2008_percentile_data import score_distributions

'''
Name                                                                                                                Stmts   Miss  Cover
---------------------------------------------------------------------------------------------------------------------------------------
/home/jyan/.virtualenvs/python2.7-env/lib/python2.7/site-packages/pkg_resources/__init__.py                          1553    897    42%
/home/jyan/.virtualenvs/python2.7-env/lib/python2.7/site-packages/pkg_resources/_vendor/__init__.py                     0      0   100%
/home/jyan/.virtualenvs/python2.7-env/lib/python2.7/site-packages/pkg_resources/_vendor/appdirs.py                    250    219    12%
/home/jyan/.virtualenvs/python2.7-env/lib/python2.7/site-packages/pkg_resources/_vendor/packaging/__about__.py         10      0   100%
/home/jyan/.virtualenvs/python2.7-env/lib/python2.7/site-packages/pkg_resources/_vendor/packaging/__init__.py           3      0   100%
/home/jyan/.virtualenvs/python2.7-env/lib/python2.7/site-packages/pkg_resources/_vendor/packaging/_compat.py           12      1    92%
/home/jyan/.virtualenvs/python2.7-env/lib/python2.7/site-packages/pkg_resources/_vendor/packaging/_structures.py       41     17    59%
/home/jyan/.virtualenvs/python2.7-env/lib/python2.7/site-packages/pkg_resources/_vendor/packaging/markers.py          130     73    44%
/home/jyan/.virtualenvs/python2.7-env/lib/python2.7/site-packages/pkg_resources/_vendor/packaging/requirements.py      72     25    65%
/home/jyan/.virtualenvs/python2.7-env/lib/python2.7/site-packages/pkg_resources/_vendor/packaging/specifiers.py       284    202    29%
/home/jyan/.virtualenvs/python2.7-env/lib/python2.7/site-packages/pkg_resources/_vendor/packaging/version.py          150     49    67%
/home/jyan/.virtualenvs/python2.7-env/lib/python2.7/site-packages/pkg_resources/_vendor/pyparsing.py                 2533   1419    44%
/home/jyan/.virtualenvs/python2.7-env/lib/python2.7/site-packages/pkg_resources/_vendor/six.py                        444    204    54%
/home/jyan/.virtualenvs/python2.7-env/lib/python2.7/site-packages/pkg_resources/extern/__init__.py                     35      6    83%
/home/jyan/.virtualenvs/python2.7-env/lib/python2.7/site-packages/pkg_resources/py31compat.py                          12      5    58%
mhci_comblib_sidney2008_percentile_data/__init__.py                                                                     7      0   100%
tests.py                                                                                                               17      0   100%
---------------------------------------------------------------------------------------------------------------------------------------
TOTAL                                                                                                                5553   3117    44%
'''	
class ScoreDistributionsTests(TestCase):

    def test_H2(self):
        distribution = score_distributions[('comblib_sidney2008', 'H-2-Db', 9)]
        expected_distribution = [8.12830516164e-07, 3.31894457553e-06, 4.45656248398e-06, 6.2086903423e-06, 7.4644875841e-06, 8.51138038202e-06, 9.52796164024e-06, 1.05681750921e-05, 1.23879658653e-05, 1.39636836106e-05, 1.57398286447e-05, 1.69824365246e-05, 1.78648757485e-05, 1.94984459976e-05, 2.07491351745e-05, 2.19785987278e-05, 2.26464430759e-05, 2.37137370566e-05, 2.5003453617e-05, 2.72270130808e-05, 2.95120922667e-05, 3.06196343369e-05, 3.22106879128e-05, 3.42767786546e-05, 3.6307805477e-05, 3.74110588272e-05, 3.86366977054e-05, 4.11149721105e-05, 4.29536426765e-05, 4.40554863507e-05, 4.52897579904e-05, 4.67735141287e-05, 4.85288500162e-05, 4.94310686987e-05, 5.10504999975e-05, 5.22396188999e-05, 5.3703179637e-05, 5.49540873858e-05, 5.64936974812e-05, 5.91561634175e-05, 6.22300285169e-05, 6.3095734448e-05, 6.56145266303e-05, 6.83911647281e-05, 6.95024317589e-05, 7.11213513653e-05, 7.24435960075e-05, 7.48169500511e-05, 7.81627804588e-05, 7.99834255007e-05, 8.14704284021e-05, 8.37529282127e-05, 8.53100114018e-05, 8.68960429286e-05, 8.87156012038e-05, 9.03649473722e-05, 9.20449571753e-05, 9.41889596523e-05, 9.59400631516e-05, 9.79489985409e-05, 9.93116048421e-05, 0.000100925288608, 0.000101859138805, 0.000103752841582, 0.000105438689639, 0.000106905487922, 0.000109395636627, 0.000111173172728, 0.000112460497397, 0.000114287833479, 0.000116412602941, 0.000118032063565, 0.000119398810446, 0.000120781383511, 0.000122179966016, 0.000124738351424, 0.000126182753459, 0.000127643880881, 0.000128824955169, 0.000131219989902, 0.000133045441798, 0.000135518941235, 0.00013677288256, 0.00013803842646, 0.000140281370456, 0.00014256075936, 0.000146554784096, 0.000149623565609, 0.000152054752973, 0.000154525443954, 0.000155955250283, 0.000157398286447, 0.000159587914724, 0.000161808003764, 0.000163305194789, 0.000164437172321, 0.000166341265037, 0.000167880401812, 0.000170215850839, 0.000172186857499, 0.000174180687339, 0.000196788628971, 0.000220292646305, 0.000246603933723, 0.000270395836411, 0.000296483138952, 0.000326587832172, 0.000352370871042, 0.000379314984974, 0.000407380277804, 0.000437522105158, 0.000467735141287, 0.000503500608788, 0.000538269782516, 0.000570164272281, 0.000603948629376, 0.000635330931852, 0.000666806769214, 0.000696626514111, 0.000736207097495, 0.000781627804588, 0.000822242649947, 0.000872971368388, 0.000924698173938, 0.000970509967245, 0.00101157945426, 0.0010616955572, 0.00111686324778, 0.00116412602941, 0.00121618600065, 0.00127350308102, 0.00132434153519, 0.00138356637897, 0.00143879857826, 0.00150314196609, 0.00158124803927, 0.00166341265037, 0.00173780082875, 0.00181551566277, 0.00190107827992, 0.00198152702581, 0.00206062991327, 0.00214289060112, 0.00223357222283, 0.00234963282085, 0.00245470891569, 0.00256448403652, 0.00268534444566, 0.00279254384124, 0.00292415237784, 0.00304088502568, 0.00315500462337, 0.00327340694879, 0.00341979442514, 0.00354813389234, 0.00370680721783, 0.00384591782045, 0.00400866717627, 0.00417830366647, 0.00437522105158, 0.00458141886715, 0.00479733448637, 0.00504661297564, 0.00529663443892, 0.00554625712958, 0.00578096047406, 0.00603948629376, 0.00638263486191, 0.00669884609417, 0.00709577767963, 0.00743019137897, 0.0078523563461, 0.00826037949577, 0.00870963589956, 0.00909913272632, 0.00968277856261, 0.0102801629813, 0.011040786199, 0.0117489755494, 0.0125314117494, 0.0136458313659, 0.0146217717446, 0.0159220872705, 0.0174984668862, 0.0192752491319, 0.022181964198, 0.0251188643151, 0.0296483138952, 0.0366437574648, 0.0514043651582]
        self.assertEqual(distribution, expected_distribution)

    def test_HLA(self):
        distribution = score_distributions[('comblib_sidney2008', 'HLA-A02:01', 9)]
        expected_distribution = [7.37904230129e-07, 3.31131121483e-06, 4.38530697775e-06, 6.16595001861e-06, 8.14704284021e-06, 9.31107875468e-06, 1.07398941234e-05, 1.28943661996e-05, 1.502449903e-05, 1.69824365246e-05, 1.91866874067e-05, 2.06538015581e-05, 2.19785987278e-05, 2.39883291902e-05, 2.63876065531e-05, 2.77332010465e-05, 3.04649170526e-05, 3.17687407065e-05, 3.31894457553e-05, 3.52208635618e-05, 3.78791303785e-05, 3.926449354e-05, 4.11528578436e-05, 4.26579518802e-05, 4.41570447353e-05, 4.58141886715e-05, 4.7108578542e-05, 5.01187233627e-05, 5.16178605497e-05, 5.30884444231e-05, 5.41876104452e-05, 5.6234132519e-05, 5.72532309394e-05, 5.88843655356e-05, 6.14044718106e-05, 6.33869711257e-05, 6.59629393745e-05, 6.79203632617e-05, 6.91830970919e-05, 7.09577767963e-05, 7.24769651993e-05, 7.34852202192e-05, 7.56310273906e-05, 7.73036499601e-05, 7.88133885093e-05, 8.06306201355e-05, 8.27942163712e-05, 8.47227414141e-05, 8.70963589956e-05, 8.88791719885e-05, 9.07820530178e-05, 9.2896638678e-05, 9.35836543584e-05, 9.56312868846e-05, 9.84011105761e-05, 9.96322641954e-05, 0.000101906057475, 0.000103896280491, 0.00010626738654, 0.000108043837237, 0.000109420828804, 0.000112719745618, 0.000115611224219, 0.000116734707649, 0.000119398810446, 0.000120864845158, 0.000122857026525, 0.000124738351424, 0.000126765186586, 0.000128943661996, 0.000130737447016, 0.000132434153519, 0.000134276496114, 0.000136804379306, 0.000138356637897, 0.000140604752413, 0.000142167393131, 0.000144577263387, 0.000146892627764, 0.000148388416377, 0.00015079953418, 0.000153532386279, 0.000155238700996, 0.000158161217701, 0.000159845347462, 0.000162554875575, 0.000164437172321, 0.000166379570939, 0.000168112497448, 0.000169668023235, 0.000171474679579, 0.000172742817967, 0.000175549662962, 0.000178361041643, 0.000180967255479, 0.00018146797794, 0.000183147080466, 0.000184374136777, 0.000186122981127, 0.000189277939703, 0.000191866874067, 0.000216172278434, 0.000243220400907, 0.000269401494106, 0.000294171096975, 0.00032070076803, 0.000351722377379, 0.000377485261724, 0.000402902535083, 0.000433510878388, 0.000468813382145, 0.000503500608788, 0.000542000890402, 0.000575439937337, 0.000612350391725, 0.000649082649132, 0.000688652296344, 0.000722936246661, 0.00076032627694, 0.000807606861329, 0.000847617666635, 0.00089784217091, 0.000944713235727, 0.00100092145832, 0.00106218459867, 0.00111634903166, 0.00117219536555, 0.00122687410464, 0.00127761499397, 0.0013261724451, 0.00138484127772, 0.00145144304943, 0.00151356124844, 0.00157398286447, 0.00163757047688, 0.00171001531509, 0.00178648757485, 0.00187499450807, 0.0019696996149, 0.00205541726418, 0.00213255381795, 0.00224388192378, 0.00234638892446, 0.00244343055269, 0.00255505351051, 0.00266685866452, 0.00279383015136, 0.0029066985903, 0.00303598764599, 0.00317760565716, 0.00331894457553, 0.00346497415829, 0.00365931671975, 0.00380539725003, 0.00397557544927, 0.0041304750199, 0.00433510878388, 0.00454150712633, 0.00473696308175, 0.00494424519334, 0.00515703406303, 0.00540754322946, 0.0056234132519, 0.00586408153276, 0.00612350391725, 0.00646249172495, 0.00670347509173, 0.00710231614301, 0.0074834179274, 0.00787771019586, 0.00834065197409, 0.00881048873008, 0.00925550244763, 0.00977237220956, 0.0102423591412, 0.0108417652615, 0.0115345325782, 0.0122518028574, 0.0132373179379, 0.0141905752169, 0.0154170045295, 0.0168655302539, 0.0183653834335, 0.0202768271952, 0.022181964198, 0.0247742205763, 0.0280156046426, 0.0331131121483, 0.0400866717627, 0.0531740818827]
        self.assertEqual(distribution, expected_distribution)



    def test_key_error(self):
        with self.assertRaises(KeyError):
            distribution = score_distributions[('ann', 'SLA-1*0401', 9)]


if __name__ == '__main__':
    unittest.main()
