"""
created on 11/18/2019
@author: Yan
"""
from unittest import TestCase
from netmhcpan_4_1_executable import predict_many

class NetMHCpanExecutableTest(TestCase):
    '''test cases for netmhcpan 4.0 and netmhcpan_el 4.0'''
    def test_basic(self):
        allele_name = 'HLA-A*02:01'
        binding_length = '9'
        sequence = "SLYNTVATLYCVHQRIDV"

        sequence_list = [sequence,]
        allele_length_2tuple_list = [(allele_name, binding_length),]

        results = predict_many(sequence_list, allele_length_2tuple_list)
        print('Results:\n{}'.format(results))
        scores = list(results.values())
        print(scores)
        expected_scores = [[46.5, 'SLYNTVATL', 'SLYNTVATL', 30582.45, 'LYNTVATLY', 'LYNTVATLY', 28947.48, 'YNTVATLYC', 'YNTVATLYC', 124.1, 'NTVATLYCV', 'NTVATLYCV', 32503.66, 'TVATLYCVH', 'TVATLYCVH', 32260.16, 'VATLYCVHQ', 'VATLYCVHQ', 27059.95, 'ATLYCVHQR', 'ATLYCVHQR', 312.42, 'TLYCVHQRI', 'TLYCVHQRI', 45540.65, 'LYCVHQRID', 'LYCVHQRID', 21962.84, 'YCVHQRIDV', 'YCVHQRIDV']]
        
        self.assertEqual(expected_scores, scores)

    def test_el(self):
        allele_name = 'HLA-A*02:01'
        binding_length = '9'
        sequence = "SLYNTVATLYCVHQRIDV"

        sequence_list = [sequence,]
        allele_length_2tuple_list = [(allele_name, binding_length),]

        results = predict_many(sequence_list, allele_length_2tuple_list, el=True)
        print('Results:\n{}'.format(results))
        scores = list(results.values())
        print(scores)
        expected_scores = [[0.828183, 'SLYNTVATL', 'SLYNTVATL', 0.000583, 'LYNTVATLY', 'LYNTVATLY', 6e-05, 'YNTVATLYC', 'YNTVATLYC', 0.039677, 'NTVATLYCV', 'NTVATLYCV', 5.5e-05, 'TVATLYCVH', 'TVATLYCVH', 3.1e-05, 'VATLYCVHQ', 'VATLYCVHQ', 0.000402, 'ATLYCVHQR', 'ATLYCVHQR', 0.091622, 'TLYCVHQRI', 'TLYCVHQRI', 0.0, 'LYCVHQRID', 'LYCVHQRID', 0.00061, 'YCVHQRIDV', 'YCVHQRIDV']]
        self.assertEqual(expected_scores, scores)
