#! /usr/bin/python
import os
import sys
import unittest
import json
#from distutils.spawn import find_executable
import subprocess


class UtilTest(unittest.TestCase):

    def test_example(self):
        self.assertEqual(1, 1)

    def test_os_popen_example(self):
        cmd = 'echo example'
        with os.popen(cmd) as process:
            result = process.read()
        self.assertEqual(result, 'example\n')

    def test_help(self):
        cmd = 'python3 src/tcell_mhcii.py -h'
        with os.popen(cmd) as process:
            result = process.read()

        with open(os.path.join(os.path.dirname(__file__), 'src', 'example_commands.txt'), 'r') as f:
            expected_output = f.read() + "\n"
        self.assertEqual(result, expected_output)

        # If no options are given, help info will be returned as well
        cmd = 'python3 src/tcell_mhcii.py'
        with os.popen(cmd) as process:
            result = process.read()
        self.assertEqual(result, expected_output)

    def test_versions(self):
        cmd = 'python3 src/tcell_mhcii.py -v'
        with os.popen(cmd) as process:
            result = process.read()
        expected_output = (
            "tool_group\tmethod\tversion\n"
            "-------\t-------\t-------\n"
            "binding\tNetMHCIIpan EL\t4.1\n"
            "binding\tNetMHCIIpan BA\t4.1\n"
            "binding\tNetMHCIIpan EL\t4.3\n"
            "binding\tNetMHCIIpan BA\t4.3\n"
            "binding\tNetMHCIIpan EL\t4.2\n"
            "binding\tNetMHCIIpan BA\t4.2\n"
            "binding\tNetMHCIIpan EL\t4.0\n"
            "binding\tNetMHCIIpan BA\t4.0\n"
            "binding\tNetMHCIIpan\t3.2\n"
            "binding\tNetMHCIIpan\t3.1\n"
            "binding\tSMM_align (NetMHCII) *\t1.1\n"
            "binding\tNN_align (NetMHCII) *\t2.2\n"
            "binding\tNN_align (NetMHCII) *\t2.3\n"
            "binding\tCombinatorial library\t1.0\n"
            "binding\tSturniolo\t1.0\n"
            "immunogencity\CD4Episcore\t1.0\n"
            "processing\tMHCII-NP\t1.0\n"
            "\n"
        )
        self.assertEqual(result, expected_output)


class TestCommonPrediction(unittest.TestCase):
    maxDiff = None

    """
    def test_binding_prediction(self):
        cmd = "python3 src/tcell_mhcii.py --method=netmhciipan_el --allele=HLA-DRB1*01:01 -p examples/test.pep"
        with os.popen(cmd) as process:
            result = process.read()
        expected_output = (
            "allele\tpeptide\tcore\ticore\tscore\tpercentile\n"
            "HLA-DRB1*01:01\tKMKGDYFRY\tKMKGDYFRY\tKMKGDYFRY\t0.00605\t6.3\n"
            "HLA-DRB1*01:01\tTMDKSELVQK\tTMDSELVQK\tTMDKSELVQK\t0.001846\t11\n"
            "HLA-DRB1*01:01\tEILNSPEKAC\tELNSPEKAC\tEILNSPEKAC\t0.000223\t25\n"
        )
        self.assertEqual(result, expected_output)
    """
    def test_json_input(self):
        cmd = "python3 src/tcell_mhcii.py -j examples/binding.json"
        with os.popen(cmd) as process:
            result = process.read()
        expected_output = (
            """allele	seq_num	start	end	peptide_length	core	peptide	score	percentile
HLA-DRB1*01:01	1	1	15	15	VTMFEALPH	MGQIVTMFEALPHII	0.018185	33.0
HLA-DRB1*01:01	1	2	16	15	VTMFEALPH	GQIVTMFEALPHIID	0.048394	21.0
HLA-DRB1*01:01	1	3	17	15	MFEALPHII	QIVTMFEALPHIIDE	0.09149	15.0
HLA-DRB1*01:01	1	4	18	15	FEALPHIID	IVTMFEALPHIIDEV	0.122673	13.0
HLA-DRB1*01:01	1	5	19	15	FEALPHIID	VTMFEALPHIIDEVI	0.086209	15.0
HLA-DRB1*01:01	1	6	20	15	FEALPHIID	TMFEALPHIIDEVIN	0.02684	28.0
HLA-DRB1*01:01	1	7	21	15	FEALPHIID	MFEALPHIIDEVINI	0.004652	57.0
HLA-DRB1*01:01	1	8	22	15	PHIIDEVIN	FEALPHIIDEVINIV	0.001389	81.0
HLA-DRB1*01:01	1	9	23	15	IIDEVINIV	EALPHIIDEVINIVI	0.003151	65.0
HLA-DRB1*01:01	1	10	24	15	IIDEVINIV	ALPHIIDEVINIVII	0.004537	57.0
HLA-DRB1*01:01	1	11	25	15	IIDEVINIV	LPHIIDEVINIVIIV	0.005345	54.0
HLA-DRB1*01:01	1	12	26	15	IIDEVINIV	PHIIDEVINIVIIVL	0.002703	68.0
HLA-DRB1*01:01	1	13	27	15	IIDEVINIV	HIIDEVINIVIIVLI	0.000515	95.0
HLA-DRB1*01:01	1	14	28	15	INIVIIVLI	IIDEVINIVIIVLIV	0.00077	90.0
HLA-DRB1*01:01	1	15	29	15	INIVIIVLI	IDEVINIVIIVLIVI	0.001138	84.0
HLA-DRB1*01:01	1	16	30	15	INIVIIVLI	DEVINIVIIVLIVIT	0.001635	78.0
HLA-DRB1*01:01	1	17	31	15	IVIIVLIVI	EVINIVIIVLIVITG	0.00074	91.0
HLA-DRB1*01:01	1	18	32	15	IIVLIVITG	VINIVIIVLIVITGI	0.001701	78.0
HLA-DRB1*01:02	1	1	15	15	VTMFEALPH	MGQIVTMFEALPHII	0.086097	21.0
HLA-DRB1*01:02	1	2	16	15	VTMFEALPH	GQIVTMFEALPHIID	0.191762	13.0
HLA-DRB1*01:02	1	3	17	15	MFEALPHII	QIVTMFEALPHIIDE	0.187851	13.0
HLA-DRB1*01:02	1	4	18	15	MFEALPHII	IVTMFEALPHIIDEV	0.196748	13.0
HLA-DRB1*01:02	1	5	19	15	MFEALPHII	VTMFEALPHIIDEVI	0.081593	22.0
HLA-DRB1*01:02	1	6	20	15	MFEALPHII	TMFEALPHIIDEVIN	0.009557	56.0
HLA-DRB1*01:02	1	7	21	15	PHIIDEVIN	MFEALPHIIDEVINI	0.002073	82.0
HLA-DRB1*01:02	1	8	22	15	PHIIDEVIN	FEALPHIIDEVINIV	0.003598	74.0
HLA-DRB1*01:02	1	9	23	15	IIDEVINIV	EALPHIIDEVINIVI	0.010621	54.0
HLA-DRB1*01:02	1	10	24	15	IIDEVINIV	ALPHIIDEVINIVII	0.016705	45.0
HLA-DRB1*01:02	1	11	25	15	IIDEVINIV	LPHIIDEVINIVIIV	0.01905	43.0
HLA-DRB1*01:02	1	12	26	15	IIDEVINIV	PHIIDEVINIVIIVL	0.00973	55.0
HLA-DRB1*01:02	1	13	27	15	INIVIIVLI	HIIDEVINIVIIVLI	0.001432	87.0
HLA-DRB1*01:02	1	14	28	15	INIVIIVLI	IIDEVINIVIIVLIV	0.002791	78.0
HLA-DRB1*01:02	1	15	29	15	INIVIIVLI	IDEVINIVIIVLIVI	0.004858	69.0
HLA-DRB1*01:02	1	16	30	15	INIVIIVLI	DEVINIVIIVLIVIT	0.006982	62.0
HLA-DRB1*01:02	1	17	31	15	IVIIVLIVI	EVINIVIIVLIVITG	0.003447	74.0
HLA-DRB1*01:02	1	18	32	15	IIVLIVITG	VINIVIIVLIVITGI	0.009442	56.0
"""
        )
        self.assertEqual(result, expected_output)

    def test_json_output(self):
        cmd = "python3 src/tcell_mhcii.py -j examples/binding.json -o output -f json"
        with os.popen(cmd) as process:
            printed_result = process.read()
        with open('output.json', 'r') as f:
            result = json.load(f)
        with open('test_data/expected_output.json', 'r') as f:
            expected_output = json.load(f)
        self.assertEqual(result, expected_output)

    def test_warning(self):
        cmd = ["python3", "src/tcell_mhcii.py", "-j", "test_data/warnings_binding.json"]
        with subprocess.Popen(cmd, stdout=subprocess.PIPE, stderr=subprocess.PIPE) as process:
            stdoutdata, stderrdata = process.communicate()
        warnings = stderrdata.decode()
        expected_output = (
            "'input_sequence_text'\n"
        )
        self.assertEqual(warnings, expected_output)

class TestProcessingPrediction(unittest.TestCase):
    #maxDiff = None

    def test_mhciinp(self):
        cmd="python3 src/tcell_mhcii.py  -j test_data/processing/mhciinp/input.json -o test_data/processing/mhciinp/output -f json"
        with os.popen(cmd) as process:
            printed_result = process.read()
        with open('test_data/processing/mhciinp/output.json','r') as f:
            result = json.load(f)
        with open('test_data/processing/mhciinp/expected_output.json','r') as f:
            expected_output = json.load(f)
        self.assertEqual(result, expected_output)

if __name__ == '__main__':
    unittest.main()

