'''
Created on Oct 7th, 2019
@author: Yan
The code coverage by tests is 98%. (__init__.py)  
'''
from unittest import TestCase
import unittest
from mhcii_comblib_predictor import single_prediction_comblib

'''
$ coverage report
Name                                                                                                        Stmts   Miss  Cover
-------------------------------------------------------------------------------------------------------------------------------
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/pkg_resources/__init__.py                         1607    988    39%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/pkg_resources/_vendor/__init__.py                    0      0   100%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/pkg_resources/_vendor/packaging/__about__.py        10      0   100%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/pkg_resources/_vendor/packaging/__init__.py          3      0   100%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/pkg_resources/_vendor/packaging/_compat.py          12      1    92%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/pkg_resources/_vendor/packaging/_structures.py      41     17    59%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/pkg_resources/_vendor/packaging/specifiers.py      281    201    28%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/pkg_resources/_vendor/packaging/version.py         150     78    48%
mhcii_comblib_predictor/__init__.py                                                                            51      1    98%
tests.py                                                                                                       27      0   100%
-------------------------------------------------------------------------------------------------------------------------------
TOTAL                                                                                                        2182   1286    41%
'''

class MHCIIComblibPredictorTests(TestCase):

    def test_HLA_prediction(self):
        result = single_prediction_comblib(['ASSASSSSAAAAAAAT',], [('DRB1*01:01', 15),])
        expected_result = {('ASSASSSSAAAAAAAT', 'DRB1*01:01', 15): (('SSSAAAAAA', 0.022254301136598206), ('SSSAAAAAA', 0.022254301136598206))}
        self.assertEqual(result, expected_result)

    def test_length(self):
        result = single_prediction_comblib(['ASSASSSSAAAAAAAT',], [('DRB1*01:01', 10),])
        expected_result = {('ASSASSSSAAAAAAAT', 'DRB1*01:01', 10): (('ASSASSSSA', 1321.147539705814), ('SASSSSAAA', 40.174708119705095), ('ASSSSAAAA', 0.4607460221810984), ('SSSSAAAAA', 0.43578162791326047), ('SSSAAAAAA', 0.022254301136598206), ('SSSAAAAAA', 0.022254301136598206), ('SSAAAAAAA', 0.03898759842239447))}
        self.assertEqual(result, expected_result)

    def test_sequence_list(self):
        result = single_prediction_comblib(['GHAHKVPRRLLKAAR', 'LKAADASADADGSGSGSGSG'], [('DRB1*01:01', 10),])
        expected_result =  {('LKAADASADADGSGSGSGSG', 'DRB1*01:01', 10): (('LKAADASAD', 299574.8346224409), ('AADASADAD', 1000000), ('ADASADADG', 1000000), ('DASADADGS', 1000000), ('ASADADGSG', 1000000), ('SADADGSGS', 1000000), ('ADADGSGSG', 1000000), ('DADGSGSGS', 1000000), ('ADGSGSGSG', 1000000), ('DGSGSGSGS', 1000000), ('GSGSGSGSG', 1000000)), ('GHAHKVPRRLLKAAR', 'DRB1*01:01', 10): (('HAHKVPRRL', 0.19159306862646408), ('HAHKVPRRL', 0.19159306862646408), ('AHKVPRRLL', 65.62544427061458), ('KVPRRLLKA', 1000000), ('VPRRLLKAA', 167.071365673583), ('PRRLLKAAR', 1.160286327678153))}
        self.assertEqual(result, expected_result)

    def test_wrong_coreseq_len(self):
        with self.assertRaises(Exception):
            result = single_prediction_comblib(['ASSASSSSAAAAAAAT',], [('DRB1*01:01', 10),], 10)

    def test_ValueError(self):
        with self.assertRaises(ValueError):
            result = single_prediction_comblib('ASSASSSSAAAAAAAT', 'DRB1*01:01', 20)

    def test_KeyError(self):
        with self.assertRaises(KeyError):
            result = single_prediction_comblib('ASSASSSSAAAAAAAT', [('H2-IAb', 15),])


if __name__ == '__main__':
    unittest.main()
