'''
Created on Jan 27, 2016

@author: jivan
'''
import unittest
from mhcii_tepitope_predictor_data import data_manager

class PercentileManagerTests(unittest.TestCase):
    def test_basic(self):
        allele_name = 'DRB1*01:01'
        lookup_dict = data_manager.get_analytical_data(allele_name)
        expected_amino_acids = set([
            'A', 'C', 'D', 'E', 'G', 'F', 'I', 'H', 'K', 'M', 'L', 'N', 'Q', 'P', 'S',
            'R', 'T', 'W', 'V', 'Y'
        ])

        self.assertSetEqual(set(lookup_dict.keys()), expected_amino_acids)
        for amino_acid in lookup_dict.keys():
            self.assertEqual(len(lookup_dict[amino_acid]), 9)

if __name__ == '__main__':
    unittest.main()
