#!/usr/bin/python

import logging
from subprocess import CalledProcessError
logger = logging.getLogger(__name__)


class SevenAllele():

    def do_prediction(self, pep_dict, cd4_dir):
        import pandas as pd
        from mhc_class_II_standalone import mhcII_SA
        mhc_ii_sa = mhcII_SA()
        # pred_file = tempfile.NamedTemporaryFile(delete=False,suffix="_7allele.csv")
        pred_file = cd4_dir + "/7allele_raw.csv"
        pred_result = mhc_ii_sa.pred(pep_dict, pred_file)
        # {'err': 'The sequences dataset is too large for the Seven allele. Please split it and try again. Please contact us if you have questions.' }
        if type(pred_result) is dict:
            return pred_result
        logger.info('Predicting peptides for seven allele method and updating in file = ' + str(pred_file))
        df = pd.read_csv(pred_file, sep="\t", low_memory=False)
        df_pivot = df.pivot_table(index='peptide', columns='allele', values='percentile_rank').reset_index()
        df_pivot['Median'] = df_pivot.filter(like="HLA-DR").median(axis=1)
        HLA = list(df_pivot.filter(like="HLA-DR"))
        columns = ['peptide', 'Median']
        columns.extend(HLA)
        df_final = df_pivot[columns]  # .sort_values(['seq_num','start'],ascending=[True,True])
        # seven_allele_result = tempfile.NamedTemporaryFile(delete=False,suffix="_7allele_result.csv")
        seven_allele_result = cd4_dir + "/7allele_processed.csv"
        df_final.to_csv(seven_allele_result, index=False)
        return seven_allele_result


class Immunogenicity():
    def pep2txt(self, pep_dict, cd4_dir, peptide_spacing=5):
        import tempfile
        import os, sys
        import subprocess, shlex
        import logging
        infile = open(cd4_dir + "/NN_input.txt", 'wt')
        for pepname, pep in pep_dict.items():
            infile.write(pep + "\t" + pepname + "\n")
        infile.close()
        NN_path = os.path.dirname(__file__)
        R_path = subprocess.check_output("which R", shell=True).rstrip()

        tmpdir = tempfile.mkdtemp(prefix='NNmodel_', dir=cd4_dir)
        cmd = "perl " + NN_path + "/nnalign/nnalign-1.4.SA.pl  -r " + str(
            tmpdir) + " -P web  -l 2 -H 2 -I 9 -e 1 -m 9 -n 5 -B 2 -s 10 -b 4 -X -A -O -R " + str(R_path) + " -M " + NN_path + "/model_edita_inhouse_tetramer_overlapping.txt  -x " + str(
            infile.name)
        # cmd=" -r /tmp/ -P web  -l 2 -H 2 -I 9 -e 1 -m 9 -n 5 -B 2 -s 10 -b 4 -X -A -O -R /usr/bin/R -M CD4episcore/model_edita_inhouse_tetramer_overlapping.txt  -x "+str(infile.name)

        print("Command for immunogenicity %s = ", cmd)

        try:
            runcode = subprocess.Popen(cmd, shell=True, stdout=subprocess.PIPE, stderr=subprocess.PIPE)
            print('Immunogenicity Run successful')
            for line in runcode.stdout:
                if line.decode('utf-8').startswith("# Predictions saved in "):
                    outputfile = line.decode('utf-8').replace("# Predictions saved in ", '').rstrip()
                    return outputfile
                else:
                    print(line.decode('utf-8'))
        except(OSError, CalledProcessError) as exception:
            print('Exception :' + str(exception))
            print('The immunogenicity code is not running')
            raise
        # runcode=subprocess.Popen(cmd,shell=True, stdout=subprocess.PIPE,stderr=subprocess.PIPE)

