#!/usr/bin/python
'''
inc=(5);
pepmer=(15);
protein="APPRLICDSRVLERYLLEAKEAENITTGCAEHCSLNENITVPDTKVNFYAWKRMEVGQQAVEVWQGLALLSEAVLRGQALLVNSSQPWEPLQLHVDKAVSGLRSLTTLLRALGAQKEAISPPDAASAAPLRTITADTFRKLFRVYSNFLRGKLKLYTGEACRTGDRDTFRKLFRVYSNFLR"
#peptide="ICDSRVLERYLLEAK"
peptide="VLERYLLEAKEAENI"
#peptide="GKLKLYTGEACRTGD"
peptide="DTFRKLFRVYSNFLR"
'''
class protein_to_peptide_kmer():
        def kmer(self,protein,sequence_number,pepmer=15,inc=5):
                entry_list=[];
                entry_pos=[];
        #print(protein)
                for i in range(0,len(protein),inc):
                        newpep=str(protein[i:i + pepmer])
                        if(len(newpep)>=pepmer):
                #print(newpep);
                                entry_list.append(newpep);
                                entry_pos.append(str(sequence_number) + "_" + str(i+1) + "-" + str(i+pepmer)+"_"+str(protein));
                        else:
                #print(newpep);
                                newpep=str(protein[-(int(pepmer)):])
                                entry_list.append(newpep);
                                entry_pos.append(str(sequence_number) + "_" + str(len(protein)-pepmer+1) + "-" + str(len(protein))+"_"+str(protein));
                
                #print(entry_list)
                #print(entry_pos)
                dictionary = dict(zip(entry_pos, entry_list))
                return dictionary
        def kmer2(self,protein,sequence_number,pepmer=15,inc=5,start=0):
                entry_list=[];
                entry_pos=[];
        #print(protein)
                for i in range(0,len(protein),inc):
                        newpep=str(protein[i:i + pepmer])
                        if(len(newpep)>=pepmer):
                #print(newpep);
                                entry_list.append(newpep);
                                entry_pos.append(str(sequence_number) + "_" + str(i+1+start) + "-" + str(i+pepmer+start));
                
                        else:
                                newpep=str(protein[-(int(pepmer)):])
                                entry_list.append(newpep);
                                entry_pos.append(str(sequence_number) + "_" + str(len(protein)-pepmer+1+start) + "-" + str(len(protein)+start));
                #print(newpep);
                #print(entry_list)
                #print(entry_pos)
                dictionary = dict(zip(entry_pos, entry_list))
                return dictionary
#  print str(entry.id) #This is header of fasta entry
#  print str(entry.seq) #This is sequence of specific fasta entry
        def peptide_with_flanking_residues(self,peptide,protein,pepmer=15,inc=5):
                inx=protein.index(peptide)
                prev=post=str();
                if(inx<pepmer):
                        prev=str(protein[:inx])
                else:
                        prev=str(protein[(inx-pepmer)+inc:inx])
                if(inx<(len(protein)-2*pepmer+inc)):
                        post=str(protein[(inx+pepmer):(inx+2*pepmer-inc)])
                start=protein.index(prev)
                end=protein.index(post)+len(post)
                return prev,post,start,end
                #pep_final=prev+peptide+post;
                #return pep_final
#tp=protein_to_peptide_kmer()
#v=tp.peptide_with_flanking_residues(peptide,protein,pepmer,inc)
#print(v,peptide,"test")
#n=tp.kmer(peptide,1,5,1);
#v=tp.peptide_with_flanking_residues('RKLFR',peptide,5,1)
#print(n)
#print(v)
