### read in a table in format Name TAB Value, and plot the distribution of Value
## use as: R-2.9 --vanilla --args [input1] [input2] [title1] [title2] [output.file] < data.distrib.R

cmd_args = commandArgs(TRUE);

before = cmd_args[1];
after = cmd_args[2];
title1 = cmd_args[3];
title2 = cmd_args[4];
outfile = cmd_args[5];

pdf(outfile)
par(mfrow=c(2,1))

## distribution before the transformation
mat=as.matrix(read.delim(before,header=F))
dpt=as.numeric(mat[,2])

mind=min(dpt)
maxd=max(dpt)
printing_area=seq(from=mind, to=maxd, by=(maxd-mind)/1000)
plot (density(dpt), xlim=range(printing_area), main=title1, xlab="Signal intensity")

## distribution AFTER the transformation
mat=as.matrix(read.delim(after,header=F))
dpt=as.numeric(mat[,2])

mind=min(dpt)
maxd=max(dpt)
printing_area=seq(from=mind, to=maxd, by=(maxd-mind)/1000)
plot (density(dpt), xlim=range(printing_area), main=title2, xlab="Signal intensity")

dev.off()


