#from sample_peptides import file_paths_by_binding_length
import datetime
import pickle
import logging
from functools import reduce
logging.basicConfig(level=logging.DEBUG)
import allele_info_sql

def read_from_allele_info_mhci():
    miad = allele_info_sql.MHCIAlleleData()
    method_list = miad.get_method_names(include_hidden=True)
    species_list = miad.get_species_list()
    method_species_dict = {method:miad.get_species_list(method, include_hidden=True) for method in miad.get_method_names(include_hidden=True)}

    method_alleles_dict = {method: miad.get_allele_names_for_method(method) for method in method_list}
    #print("For MHCI------------------------------------------------------------")
    #print(species_list)
    species_alleles_dict = {species: miad.get_allele_names(species) for species in species_list}
    #print("Returned from species allele dict\n")
    #print(species_alleles_dict)
    #print("----------------------------------------------------------------------")
    all_allele_list = list(set(reduce(lambda x,y:x+y, species_alleles_dict.values())))
    all_allele_list2 = list(set(reduce(lambda x,y:x+y, method_alleles_dict.values())))

    allele_frequency_dict = {allele:miad.get_allele_frequencies([allele])[0] for allele in all_allele_list}

    method_allele_length_dict = {}
    for method in method_list:
        alleles = method_alleles_dict[method]
        method_allele_length_dict[method] = {allele: miad.get_allowed_peptide_lengths(method,allele,include_hidden=True) for allele in alleles}    
    
    #method_allele_length_dict2 = {(method,allele):miad.get_allowed_peptide_lengths(method,allele) for method,alleles in method_alleles_dict for allele in alleles}
    #return method_allele_length_dict, allele_frequency_dict

    mhci_info_dict=dict(
            method_list=method_list,
            species_list=species_list,
            method_species_dict=method_species_dict,
            species_alleles_dict=species_alleles_dict,
            method_alleles_dict=method_alleles_dict,
            allele_frequency_dict=allele_frequency_dict,
            method_allele_length_dict=method_allele_length_dict,
    )    

    return mhci_info_dict
    

def write_to_pickle(data, pickle_file_name):
    with open(pickle_file_name, 'wb') as pickle_file:
        pickle.dump(data, pickle_file)

def generate_mhci_pickle_files():
    mhci_info_dict = read_from_allele_info_mhci()
    write_to_pickle(mhci_info_dict, 'pickles/mhci_info_dict.p')

def read_from_allele_info_mhcii():
    miiad = allele_info_sql.MHCIIAlleleData()
    method_list = miiad.get_method_names()
    locus_list = miiad.get_locus_names()
    method_locus_dict = {method:miiad.get_locus_names_for_method(method) for method in method_list}

    method_allele_dict = {method:miiad.get_allele_names(method) for method in method_list}

    method_alpha_chain_dict = {(method,locus):miiad.get_alpha_chain(method,locus) for method in method_list for locus in locus_list}
    allele_a_list = list(set(reduce(lambda a,b:a+b, method_alpha_chain_dict.values())))
    method_beta_chain_dict = {(method,allele_a):miiad.get_beta_chain(method,allele_a) for method in method_list for allele_a in allele_a_list}

    locus_alpha_chain_dict = {locus:miiad.get_alpha_chains_for_locus(locus) for locus in locus_list}
    locus_beta_chain_dict = {locus:miiad.get_beta_chains_for_locus(locus) for locus in locus_list}

    mhcii_info_dict=dict(
            method_list=method_list,
            locus_list=locus_list,
            method_locus_dict=method_locus_dict,
            method_allele_dict=method_allele_dict,
            method_alpha_chain_dict=method_alpha_chain_dict,
            method_beta_chain_dict=method_beta_chain_dict,
            locus_alpha_chain_dict=locus_alpha_chain_dict,
            locus_beta_chain_dict=locus_beta_chain_dict,
    )    

    return mhcii_info_dict

def generate_mhcii_pickle_files():
    mhcii_info_dict = read_from_allele_info_mhcii()
    write_to_pickle(mhcii_info_dict, 'pickles/mhcii_info_dict.p')

def read_from_allele_info_mhcnp():
    mnpad = allele_info_sql.MHCNPAlleleData()
    method_list = mnpad.get_method_names()
    #method_alleles_dict = {method:mnpad.get_allele_names(method) for method in method_list}
    method_alleles_dict = {method: mnpad.get_allele_names_for_method(method) for method in method_list}
    #print("MHCNP : Method - Allele Dict\n")
    #print(method_alleles_dict)
    species_list = mnpad.get_species_list()
    method_species_dict = {method:mnpad.get_species_list(method, include_hidden=True) for method in mnpad.get_method_names()}
    #print(method_species_dict)
    #print("\n")
    #print(species_list)
    
    species_alleles_dict = {species: mnpad.get_allele_names(species) for species in species_list}
    #species_alleles_dict = {method: mnpad.get_allele_names(species, method) for method, species in method_species_dict.items()}

    print("Returned back from get allele names")
    #print(species_alleles_dict)

    # TODO : This is where the ERROR is coming from.
    method_allele_lengths_dict = {(method,allele):mnpad.get_allowed_peptide_lengths(method, allele) for method,alleles in method_alleles_dict.items() for allele in alleles}
    #method_allele_length_dict = {}
    #method_allele_length_dict2 = {}    
    #for method,alleles in method_alleles_dict.items():
    #    method_allele_length_dict2[method] = {allele:mnpad.get_allowed_peptide_lengths(method,allele) for allele in alleles}

    mhcnp_info_dict=dict(
            method_list=method_list,            
            method_alleles_dict=method_alleles_dict,
            method_allele_lengths_dict=method_allele_lengths_dict,            
            species_list=species_list,
            method_species_dict=method_species_dict,
            species_alleles_dict=species_alleles_dict,
    )    

    return mhcnp_info_dict

def generate_mhcnp_pickle_files():
    mhcnp_info_dict = read_from_allele_info_mhcnp()
    write_to_pickle(mhcnp_info_dict, 'pickles/mhcnp_info_dict.p')

def read_from_allele_info_netctlpan():
    ncpad = allele_info_sql.NetCTLpanAlleleData()
    method_list = ncpad.get_method_names()

    
    species_list = ncpad.get_species_list()
    
    species_alleles_dict = {species: ncpad.get_allele_names_for_species(species) for species in species_list}
    all_allele_list = list(set(reduce(lambda x,y:x+y, species_alleles_dict.values())))

    allele_lengths_dict = {allele:ncpad.get_allowed_peptide_lengths(allele) for allele in all_allele_list}
    

    netctlpan_info_dict=dict(
            method_list=method_list,
            species_list=species_list,
            species_alleles_dict=species_alleles_dict,
            allele_lengths_dict=allele_lengths_dict,            
    )    

    return netctlpan_info_dict

def generate_netctlpan_pickle_files():
    netctlpan_info_dict = read_from_allele_info_netctlpan()
    write_to_pickle(netctlpan_info_dict, 'pickles/netctlpan_info_dict.p')

if __name__ == '__main__':
    generate_mhci_pickle_files()
    generate_mhcii_pickle_files()
    generate_mhcnp_pickle_files()
    generate_netctlpan_pickle_files()
