'''
Created on Nov 13, 2015

@author: jivan
'''
import os
from celery import Celery
import logging
logger = logging.getLogger(__name__)

_udp = os.environ.get('USE_DISTRIBUTED_PROCESSING', False)
USE_DISTRIBUTED_PROCESSING = False if _udp == 'False' else bool(_udp)

_udpiw = os.environ.get('USE_DISTRIBUTED_PROCESSING_MHCI_WEB', False)
USE_DISTRIBUTED_PROCESSING_MHCI_WEB = False if _udpiw == 'False' else bool(_udpiw)

_udpia = os.environ.get('USE_DISTRIBUTED_PROCESSING_MHCI_API', False)
USE_DISTRIBUTED_PROCESSING_MHCI_API = False if _udpia == 'False' else bool(_udpia)

_udpiiw = os.environ.get('USE_DISTRIBUTED_PROCESSING_MHCII_WEB', False)
USE_DISTRIBUTED_PROCESSING_MHCII_WEB = False if _udpiiw == 'False' else bool(_udpiiw)

_udpiia = os.environ.get('USE_DISTRIBUTED_PROCESSING_MHCII_API', False)
USE_DISTRIBUTED_PROCESSING_MHCII_API = False if _udpiia == 'False' else bool(_udpiia)

_udpdeimm = os.environ.get('USE_DISTRIBUTED_PROCESSING_DEIMMUNIZATION', False)
USE_DISTRIBUTED_PROCESSING_DEIMMUNIZATION = False if _udpiia == 'False' else bool(_udpdeimm)

_udptepi = os.environ.get('USE_DISTRIBUTED_PROCESSING_TEPITOOL', False)
USE_DISTRIBUTED_PROCESSING_TEPITOOL = False if _udptepi == 'False' else bool(_udptepi)

_udpb = os.environ.get('USE_DISTRIBUTED_PROCESSING_BCELL', False)
USE_DISTRIBUTED_PROCESSING_BCELL = False if _udpb == 'False' else bool(_udpb)

_udpscep = os.environ.get('USE_DISTRIBUTED_PROCESSING_SCEPTRE', False)
USE_DISTRIBUTED_PROCESSING_SCEPTRE = False if _udpscep == 'False' else bool(_udpscep)

_udpclu = os.environ.get('USE_DISTRIBUTED_PROCESSING_CLUSTER', False)
USE_DISTRIBUTED_PROCESSING_CLUSTER = False if _udpclu == 'False' else bool(_udpclu)

_udpnp = os.environ.get('USE_DISTRIBUTED_PROCESSING_MHCNP', False)
USE_DISTRIBUTED_PROCESSING_MHCNP = False if _udpnp == 'False' else bool(_udpnp)

_udpnp = os.environ.get('USE_DISTRIBUTED_PROCESSING_LYRA', False)
USE_DISTRIBUTED_PROCESSING_LYRA = False if _udpnp == 'False' else bool(_udpnp)


_udpnp = os.environ.get('USE_DISTRIBUTED_PROCESSING_TCRMatch', False)
USE_DISTRIBUTED_PROCESSING_TCRMatch = False if _udpnp == 'False' else bool(_udpnp)


def collect_rabbit_settings_from_environment():
    rabbit_settings = {
        'RABBIT_HOST': os.environ.get('RABBIT_HOST', 'localhost'),
        'RABBIT_PORT': os.environ.get('RABBIT_PORT', '5672'),
        'RABBIT_USER': os.environ.get('RABBIT_USER', 'guest'),
        'RABBIT_PASSWORD': os.environ.get('RABBIT_PASSWORD', ''),
    }

    return rabbit_settings

# Rabbit Settings
rs = collect_rabbit_settings_from_environment()

broker_template = 'amqp://{user}:{pw}@{host}:{port}//'
# Hide the password when sending to the log file.
log_broker = broker_template.format(
                    user=rs['RABBIT_USER'], pw='**',
                    host=rs['RABBIT_HOST'], port=rs['RABBIT_PORT'])
CELERY_BROKER = broker_template.format(
                    user=rs['RABBIT_USER'], pw=rs['RABBIT_PASSWORD'],
                    host=rs['RABBIT_HOST'], port=rs['RABBIT_PORT'])
CELERY_BACKEND = CELERY_BROKER
logger.info('System {} configured for distributed processing'.format(
                'is' if USE_DISTRIBUTED_PROCESSING else 'is not')
)
logger.info('Broker expected at {}'.format(log_broker))

capp = Celery('tasks', broker=CELERY_BROKER, backend=CELERY_BACKEND)
# Time to keep uncollected results
capp.conf.CELERY_TASK_RESULT_EXPIRES = 600
capp.conf.CELERYD_TASK_TIME_LIMIT = 900 # kill worker which has been working on 1 job for more than 900 sec.
capp.conf.CELERYD_MAX_TASKS_PER_CHILD = 40
#capp.conf.CELERYD_FORCE_EXECV = True
# set prefetch number 1
capp.conf.CELERYD_PREFETCH_MULTIPLIER = 1
# to set pickle as serialization format
capp.conf.CELERY_TASK_SERIALIZER = "pickle"
capp.conf.CELERY_ACCEPT_CONTENT = ['pickle','json']
capp.conf.CELERY_RESULT_SERIALIZER = 'json'
# uniform protocol for python2 and python3
capp.conf.CELERY_TASK_PROTOCOL = 1
