'''
Created on Jun 16, 2015

@author: jivan
'''
import logging
import os
from celery import group
from celery.exceptions import TimeoutError
from .celery_app import capp, USE_DISTRIBUTED_PROCESSING
'''
# These need to be imported so their tasks are registered for workers.
from mhci.predictors.ANNPredictor import ANNPredictor  # @UnusedImport
from mhci.predictors.ComblibSidney2008Predictor import ComblibSidney2008Predictor  # @UnusedImport
from mhci.predictors.ConsensusPredictor import ConsensusPredictor  # @UnusedImport
from mhci.predictors.NetMHCPanPredictor import NetMHCPanPredictor  # @UnusedImport
from mhci.predictors.SMMPredictor import SMMPredictor  # @UnusedImport

# import another 3 celery's tasks so celery worker can register them.
from mhci.predictors.PickPocketPredictor import PickPocketPredictor
from mhci.predictors.NetMHCConsPredictor import NetMHCConsPredictor
from mhci.predictors.NetMHCStabPanPredictor import NetMHCStabPanPredictor

# import send large jobs to the "big" queue task:'mhci.forms.get_result_and_send_email'
from mhci.forms import UserInputForm

# add mhcii method
from mhcii.tasks import MhciiPrediction
'''
from mhci.seqpredictor import MHCBindingPredictions
from mhci.predictors.ConsensusPredictor import tranksform_results_to_dict
import jsonpickle

from common.utils.protection import split_prediction_request_into_number

logger = logging.getLogger(__name__)

# --- These three functions are the functions intended for use outside this module.
def distributed_predict_user_defined_allele_many(
        MHCBindingPredictions_initilization_args, method_name, sequences, allele_lengths_list, interface, split_size=24, use_distributed_processing=False):
    """ @brief: Distributed version of MHCBindingPredictions.predict_user_defined_allele_many()
        @author: Jivan
        @since: 2015-08-05
        This function takes the same arguments as predict_user_defined_allele_many(),
        preceded by a dictionary with the kwargs necessary to instantiate an
        MHCBindingPredictions instance.
        @return: The same results as MHCBindingPredictions.predict_user_defined_allele_many()
    """
    results = do_distributed_processing_for_task(task_predict_user_defined_allele_many,
        MHCBindingPredictions_initilization_args, method_name, sequences, allele_lengths_list, interface, split_size, use_distributed_processing=use_distributed_processing
    )
    return results


def distributed_predict_recommended_many(
        MHCBindingPredictions_initilization_args, method_name, sequences, allele_lengths_list, interface, split_size=24, use_distributed_processing=False, method_version=None):
    """ @brief: Distributed version of MHCBindingPredictions.predict_recommended_many()
        @author: Jivan
        @since: 2015-08-05
        This function takes the same arguments as predict_recommended_many(),
        preceded by a dictionary with the kwargs necessary to instantiate an
        MHCBindingPredictions instance.
        @return: The same results as MHCBindingPredictions.predict_recommended_many()
    """
    # TODO(JY): delete paramter "interface" here when can do this.
    results = do_distributed_processing_for_task(task_predict_recommended_many,
        MHCBindingPredictions_initilization_args, method_name, sequences, allele_lengths_list, interface, split_size, use_distributed_processing=use_distributed_processing, method_version=method_version
    )
    return results


def distributed_predict_allele_name_many(
        MHCBindingPredictions_initilization_args, method_name, sequences, allele_lengths_list, interface, split_size=24, use_distributed_processing=False):
    """ @brief: Distributed version of MHCBindingPredictions.predict_allele_name_many()
        @author: Jivan
        @since: 2015-08-05
        This function takes the same arguments as predict_allele_name_many(),
        preceded by a dictionary with the kwargs necessary to instantiate an
        MHCBindingPredictions instance.
        @return: The same results as MHCBindingPredictions.predict_allele_name_many()
    """
    results = do_distributed_processing_for_task(task_predict_allele_name_many,
        MHCBindingPredictions_initilization_args, method_name, sequences, allele_lengths_list, interface, split_size, use_distributed_processing=use_distributed_processing
    )
    return results

def split_prediction_request(sequence_list, allele_length_2tuple_list, size=1):
        """ split request parameters with certain size of batch"""        
        # JY(2017-01-27): adding a new parameter to control the size of split
        split_request = []
        num_of_allele = len(allele_length_2tuple_list)
        if num_of_allele == 0:
            return []
        if num_of_allele > size:
            for sequence in sequence_list:
                for i in range(0, num_of_allele, size):
                    split_request.append(([sequence], allele_length_2tuple_list[i:i+size]))
        else:
            for i in range(0, len(sequence_list), size//num_of_allele):
                split_request.append((sequence_list[i:i+size//num_of_allele], allele_length_2tuple_list))
        return split_request



def do_distributed_processing_for_task(
        task_to_execute,
        MHCBindingPredictions_initilization_args,
        method_name, sequences, allele_lengths_list, interface='celery', split_job_num=24, use_distributed_processing=False, method_version=None):
        # TODO(JY): delete paramter "interface" here when can do this.
    """ @brief: Distributed version of MHCBindingPredictions.predict_*_many() methods which
            breaks tasks down into small sub-tasks.
        @author: Jivan
        @since: 2015-08-04
        This function takes the same arguments as predict_user_defined_allele_many(),
        predict_recommended_many(), and predict_allele_name_many(), preceded by the corresponding
        task to execute (task_predict_user_defined_allele_many, task_predict_recommended_many, or
        task_predict_allele_name_many) and by a dictionary with the kwargs necessary to
        instantiate an MHCBindingPredictions instance.

        If environment variable USE_DISTRIBUTED_PROCESSING is set to something besides 'False'
        or something that evaluates as False when converted to bool it breaks the request
        into a number of smaller requests and queues each one for processing, then waits for each
        to complete, combines the results, then returns them.

        If environment variable USE_DISTRIBUTED_PROCESSING is not set it performs the analysis
        locally, just like calling MHCBindingPredictions.predict_user_defined_allele_many()
        would do.
    """
    # Do prediction locally if env variable USE_DISTRIBUTED_PROCESSING is not set or False.
    if not use_distributed_processing:
        logger.info('Executing {} analysis w/ {} sequences & {} alleles locally'\
                        .format(method_name, len(sequences), len(allele_lengths_list))
        )
        results = task_to_execute(
            MHCBindingPredictions_initilization_args, method_name, sequences, allele_lengths_list, method_version=method_version)
    # Do split prediction and perform remotely if env variable  USE_DISTRIBUTED_PROCESSING is set.
    else:
        logger.info('Executing {} analysis w/ {} sequences & {} alleles remotely'\
                        .format(method_name, len(sequences), len(allele_lengths_list))
        )
        # Split the sequence / allele_length lists into pieces for distribution.
        ias = MHCBindingPredictions_initilization_args
        subtask_args_list = [ (ias, method_name, sequence, allele_length, method_version)
                                for (sequence,allele_length) in split_prediction_request_into_number(sequences, allele_lengths_list, split_job_num)]

        group_task = group([ task_to_execute.subtask(subtask_args, queue=interface)
                                for subtask_args in subtask_args_list ]) # TODO(JY): delete paramter "interface" here when can do this.
        task_worker_timeout = 900
        task_request_timeout = 900
        seconds_between_polling = 1.0
        logger.info('Performing group_task.apply_async()')
        async_result = group_task.apply_async(
                           expires=task_worker_timeout, interval=seconds_between_polling
                       )
        try:
            logger.info('Performing aysync_result.get()')
            result = async_result.get(timeout=task_request_timeout)
        except TimeoutError:
            logger.error('async_result.get() timed out.')
            raise ValueError('Prediction failed, Please try again later or contact us for help.')
        except Exception as e:
            logger.error('celery error "%s": %s' % (type(e),e))
            raise ValueError('The prediction failed, Please try again later or check the help page for further information.')
        

        if async_result.failed():
            logger.error('group_task unsuccessful.')
            for n, r in enumerate(async_result.results):
                if r.successful():
                    logger.error('subtask {} was successful.'.format(n))
                else:
                    logger.error('subtask {} failed:\n{}: {}\n'.format(n, r.state))

            msgs = [ r.traceback + '\n' for r in result.results if r.failed() ]
            msg = 'Celery error while attempting distributed processing:\n{}'\
                       .format(''.join(msgs))
            logger.error(msg)
            raise Exception('group_task unsuccessful, see log for details.')

        results = {}
        for r in result: 
            r = tranksform_results_to_dict(r)
            results.update(r)

        # If env variable CHECK_DISTRIBUTED_PREDICTION_RESULTS is set, also perform the analysis
        #    locally and compare the results.
        if os.environ.get('CHECK_DISTRIBUTED_PREDICTION_RESULTS'):
            local_results = task_to_execute(
                    MHCBindingPredictions_initilization_args,
                    method_name, sequences, allele_lengths_list)
            if local_results != results:
                msg = 'Results differ between local & distributed prediction of the same data.'
                local_results_jp = repr(jsonpickle.encode(local_results))
                results_jp = repr(jsonpickle.encode(results))
                logger.error(msg)
                logger.error("local results (jsonpickle'd):\n\t{}".format(local_results_jp))
                logger.error("distributed results (jsonpickle'd):\n\t{}".format(results_jp))
                raise Exception(msg)

    return results


@capp.task(name='remote_execution.task_predict_user_defined_allele_many')
def task_predict_user_defined_allele_many(
        MHCBindingPredictions_initilization_args, method_name, sequences, allele_lengths_list, method_version=None):
    """ @brief Celery-task version of MHCBindingPredictions.predict_user_defined_allele_many()
        @author: Jivan
        @since: 2015-08-04
        This function takes the same arguments as predict_user_defined_allele_many(), preceded
        by a dictionary with the kwargs necessary to instantiate an MHCBindingPredictions
        instance.

        It simply instantiates an MHCBindingPredictions instance and calls
        predict_user_defined_allele_many() with the arguments provided.
    """
    mb_predictor = MHCBindingPredictions(**MHCBindingPredictions_initilization_args)
    results = mb_predictor.predict_user_defined_allele_many(
                method_name, sequences, allele_lengths_list)
    # for the json format and celery
    return list(results.items())


@capp.task(name='remote_execution.task_predict_recommended_many')
def task_predict_recommended_many(
        MHCBindingPredictions_initilization_args, method_name, sequences, allele_lengths_list, method_version=None):
    """ @brief Celery-task version of MHCBindingPredictions.predict_recommended_many()
        @author: Jivan
        @since: 2015-08-04
        This function takes the same arguments as predict_recommended_many(), preceded
        by a dictionary with the kwargs necessary to instantiate an MHCBindingPredictions
        instance.

        It simply instantiates an MHCBindingPredictions instance and calls
        predict_recommended_many() with the arguments provided.
    """
    mb_predictor = MHCBindingPredictions(**MHCBindingPredictions_initilization_args)
    results = mb_predictor.predict_recommended_many(
                method_name, sequences, allele_lengths_list,method_version)
    # for the json format and celery
    return list(results.items())


@capp.task(name='remote_execution.task_predict_allele_name_many')
def task_predict_allele_name_many(
        MHCBindingPredictions_initilization_args, method_name, sequences, allele_lengths_list, method_version=None):
    """ @brief Celery-task version of MHCBindingPredictions.predict_allele_name_many()
        @author: Jivan
        @since: 2015-08-04
        This function takes the same arguments as predict_allele_name_many(), preceded
        by a dictionary with the kwargs necessary to instantiate an MHCBindingPredictions
        instance.

        It simply instantiates an MHCBindingPredictions instance and calls
        predict_allele_name_many() with the arguments provided.
    """
    mb_predictor = MHCBindingPredictions(**MHCBindingPredictions_initilization_args)
    results = mb_predictor.predict_allele_name_many(
                method_name, sequences, allele_lengths_list)
    # for the json format and celery
    return list(results.items())
