'''
Created on Jun 16, 2015

@author: jivan
'''
import logging
import os
from celery import group
from celery.exceptions import TimeoutError
from .celery_app import capp, USE_DISTRIBUTED_PROCESSING
# These need to be imported so their tasks are registered for workers.
from mhci.predictors.ANNPredictor import ANNPredictor  # @UnusedImport
from mhci.predictors.ComblibSidney2008Predictor import ComblibSidney2008Predictor  # @UnusedImport
from mhci.predictors.ConsensusPredictor import ConsensusPredictor  # @UnusedImport
#from mhci.predictors.NetMHCPanPredictor import NetMHCPanPredictor  # @UnusedImport
from mhci.predictors.SMMPredictor import SMMPredictor  # @UnusedImport
#from mhci.predictors.ANN34Predictor import ANN34Predictor  # @UnusedImport
#from mhci.predictors.NetMHCPan28Predictor import NetMHCPan28Predictor  # @UnusedImport
from mhci.predictors.NetMHCPan4Predictor import NetMHCPan4Predictor  # @UnusedImport

# import another 3 celery's tasks so celery worker can register them.
from mhci.predictors.PickPocketPredictor import PickPocketPredictor
from mhci.predictors.NetMHCConsPredictor import NetMHCConsPredictor
from mhci.predictors.NetMHCStabPanPredictor import NetMHCStabPanPredictor

# import MHCI percentiles calculator:'common.utils.'
from common.utils.PercentilesCalculators import MHCIPercentilesCalculator

# import send large jobs to the "big" queue task:'mhci.forms.get_result_and_send_email'
from mhci.forms import UserInputForm

# add mhcii method
from mhcii.tasks import MhciiPrediction

# import old remote functions
from celery_tasks.distributed_predictions import distributed_predict_allele_name_many
from celery_tasks.distributed_predictions import distributed_predict_recommended_many
from celery_tasks.distributed_predictions import distributed_predict_user_defined_allele_many

# import 8 celery's tasks for the processing so celery worker can register them.
from processing.predictors.ANNPredictor import ANNPredictor 
from processing.predictors.ComblibSidney2008Predictor import ComblibSidney2008Predictor 
from processing.predictors.ConsensusPredictor import ConsensusPredictor  
from processing.predictors.NetMHCPanPredictor import NetMHCPanPredictor  
from processing.predictors.SMMPredictor import SMMPredictor 
from processing.predictors.PickPocketPredictor import PickPocketPredictor
from processing.predictors.NetMHCConsPredictor import NetMHCConsPredictor
from processing.predictors.NetMHCStabPanPredictor import NetMHCStabPanPredictor
from processing.predictors.SMMPMBECPredictor import SMMPMBECPredictor


# import 8 celery's tasks for the bcell so celery worker can register them.
from bcell.BCell import BCell
from bcell.forms import UserInputForm

# import 1 celery's task for SCEptRe
from sceptre.clustering import get_clustered_result_core

# import 1 celery's task for cluster2

from cluster2.tasks import processing

# import celery's task for mhcnp
from mhcnp.tasks import predict

# import celery's task for lyra
from lyra.tasks import predict

