import numpy as np
import pandas as pd
import random

import os
import xlrd
import argparse

import csv

BINDING_DB_FILE = 'normalized_binding_affinity_data.tsv'
AP_VALUES_DF_FILE = 'AP_fitted_values.tsv'
RESCALE_DIR_PATH = os.path.normpath(os.path.join(os.path.abspath(__file__), os.path.pardir))
BINDING_DB_FILE_PATH = os.path.join(RESCALE_DIR_PATH, BINDING_DB_FILE)
AP_VALUES_DF_FILE_PATH = os.path.join(RESCALE_DIR_PATH, AP_VALUES_DF_FILE)

binding_df = pd.read_csv(BINDING_DB_FILE_PATH, sep='\t')
binding_df.index = [8,9,10,11,12,13,14,15]                                      # changes the index of the df to this -- note that it only changes the indices of the rows here
binding_df = binding_df.drop(axis = 1, labels = 'Length')                       # drops the column 'Length'; since we are using it as our index

# print binding_df.columns.values, type(binding_df.columns.values[0])
# print binding_df.ix[15,"HLA)B*57:01"]                                           # extracts the value for that row and column
# print type(binding_df)

allele_list = list(binding_df.columns.values)                                   # get a list of all column headers -- in this case, the alleles

ap_values_df = pd.read_csv(AP_VALUES_DF_FILE_PATH, sep='\t')
ap_values_df.index = [8,9,10,11,12,13,14,15]
ap_values_df = ap_values_df.drop(axis = 1, labels = 'Length')

# print ap_values_df.ix[8,0], ap_values_df.index[0]
# print binding_df.ix[binding_df.index[2], binding_df.columns.values[-1]]
def calculate_length_rescaled_predictions(netmhc_rank,ic50_df,ap_df, ref, allele):
    adj_rank = float()
    for i in range(len(ap_df.index)):
        for j in ic50_df.columns.values:
            if len(ref) == ap_df.index[i] and str(allele) not in str(ic50_df.columns.values):
                ap_value = ap_df.ix[ap_df.index[i],0]
                # print 'entering avg', allele, netmhc_rank, ref, ic50_df.index[i], ic50_df.columns.values[-1]
                ic50_value = float(ic50_df.ix[ic50_df.index[i], ic50_df.columns.values[-1]]) ** 0.3
                Pmhc_value = ap_value*ic50_value
                adj_rank = netmhc_rank/Pmhc_value
                # print ic50_df.columns.values[j]
            if len(ref) == ap_df.index[i] and str(allele) == str(j):
                ap_value = ap_df.ix[ap_df.index[i], 0]
                ic50_value = float(ic50_df.ix[ic50_df.index[i], j]) ** 0.3
                Pmhc_value = ap_value*ic50_value
                adj_rank = netmhc_rank/Pmhc_value
                # print ic50_df.ix[ic50_df.index[i], j], j,
                # print ic50_df.ix[ic50_df.index[i], j], ic50_df.index[i], ap_value, ic50_value, ref_pep, length, allele, Pmhc_value, adj_rank
            else:
                continue

    return adj_rank
