'''
For netmhcpan 4.0
'''
from predictors.PredictorBase import MHCIPredictor, MHCIPredictionParams, get_scores_and_percentiles
from netmhcpan_4_0_executable import predict_many
from mhci_netmhcpan_4_0_el_percentile_data import score_distributions
from celery_tasks import capp

class NetMHCPan4elPredictor(MHCIPredictor):
    _score_distributions = score_distributions
    method_name = 'netmhcpan_el'
    score_decimal_places = 4
    def get_score_unit(self):
        return 'Score'

    @staticmethod
    @capp.task
    def _do_prediction(sequence_list, allele_length_2tuple_list, with_distance_info=False):
        results_without_method_name = predict_many(sequence_list, allele_length_2tuple_list, el=True, with_distance_info=with_distance_info)
        if with_distance_info:
            results_without_method_name, distances = results_without_method_name

        results = {}
        for key, scores in results_without_method_name.items():
            # Separate scores into each list
            raw_scores = scores[0::3]            
            cores = scores[1::3]
            icores = scores[2::3]

            mhci_input = MHCIPredictionParams(
                            method_name=NetMHCPan4elPredictor.method_name,
                            sequence=key.sequence,
                            allele=key.allele,
                            binding_length=key.binding_length)
            scores_and_percentiles = get_scores_and_percentiles(raw_scores, key.allele, key.binding_length, 'netmhcpan_el', score_distributions)
            scores_and_percentiles = NetMHCPan4elPredictor.combine( scores_and_percentiles, cores, icores )

            results[mhci_input] = scores_and_percentiles
        
        if with_distance_info:
            return list(results.items()), distances
        else:
            return list(results.items())

    @staticmethod
    def combine( scores, cores, icores ) :
        for i in range( len(scores) ) :
            scores[i] = scores[i] + (cores[i],)
            scores[i] = scores[i] + (icores[i],)
        return scores
