#!/usr/bin/python
import pandas as pd

def preprocess() :
    tcga_df = pd.read_csv("./data/tcga_medians.csv")
    headers = tcga_df.columns[2:]
    
    for i, row in tcga_df.iterrows() :
        for header in headers :
            tcga_df.at[i, header] = "{:6e}".format(row[header])

    # Write to csv file            
    tcga_df.to_csv("./data/tcga_medians_dev.csv", index=False)
        
    print(tcga_df.head())


preprocess()