import os
import pickle

class rankMap(object):

    def __init__(self, *args):

        rank_pickle = os.path.join(os.path.dirname(os.path.abspath(__file__)),'data/rank2ic50.pickle')
        # print("Rank Pickle file...")
        # print(rank_pickle)

        # if the ic50 tsv is not passed, use the default
        if  (len(args) > 0):
            rank_pickle = args[0]

        self.rank2ic50 = pickle.load(open( rank_pickle, "rb" ))


def main():
    rmap = rankMap()
    test_ranks = [0,1,2,3,4,5,100]
    test_ic50 = rmap.rank2ic50(test_ranks)
    print(test_ic50)

if __name__ == "__main__":
    main()