import pandas as pd
import os
import sys
from pathlib import Path
sys.path.insert(0, str(Path().absolute()))
PDIR = str(Path(__file__).absolute().parent.parent)
sys.path.insert(0, PDIR)
# from axelf import calculate_axelf_score, calculate_ic50_score, get_tcga_medians
from axelf_executable import Axelf

def main() :
    peptides = [
        'ADMGHLKY',
        'ELDDTLKY',
        'FMDHVLRY',
        'FSDLPLRV',
        'FSDNIEFY',
        'FTELAILY',
        'GLDEPLLK',
        'GLDQPLLK',
        'HIDFAIQY'
        ]

    alleles = [
        'HLA-B*52:01',
        'HLA-C*12:02',
        'HLA-A*26:01',
        'HLA-B*38:01',
        'HLA-B*52:01',
        'HLA-C*12:02',
        'HLA-C*12:02',
        'HLA-C*12:03',
        'HLA-B*07:02'
    ]

    ax = Axelf()
    ax.calculate_ic50_score(peptides, alleles)


if __name__ == "__main__" :
    main()