import os
from setuptools import setup

# allow setup.py to be run from any path
os.chdir(os.path.normpath(os.path.join(os.path.abspath(__file__), os.pardir)))

def read(fname):
    return open(os.path.join(os.path.dirname(__file__), fname)).read()

def recursive_walk(startdir):
    file_list = []
    for dirname, subdirList, fileList in os.walk(startdir, followlinks=True):
        for fname in fileList:
            file_list.append(os.path.join(dirname, fname))
            for sdname in subdirList:
                sdfiles = recursive_walk(sdname)
                file_list.extend(sdfiles)
    return file_list

# Collect the paths of all the data files for package_data.
os.chdir('axelf_executable/')
data_files = recursive_walk('data') + recursive_walk("celery_tasks") \
    + recursive_walk("length_rescaling") + recursive_walk("predictors")

with open('requirements.txt') as f:
    required = f.read().splitlines()
    
os.chdir(os.pardir)

setup(
    name='axelf-executable',
    version='0.0.3.4',
    description='An interface for calculating axelf score.',
    long_description=read('README.md'),
    packages=['axelf_executable'],
    install_requires=required,
    package_data={
        'axelf_executable': data_files 
    },
    classifiers=[
        'Intended Audience :: Developers',
        'Programming Language :: Python :: 3',
    ],
)
