"""
This package was designed to instead of local data files for MHC class II.
It provides the available methods for MHCII 'recommended' and 'consensus'.
"""

from pkg_resources import resource_filename
import pickle

package_name = 'mhcii_predictor_data'


def get_method_allele_list(method):
    """
    To provide available methods of alleles for method "recommended" and "consensus".
    example:
    >>> get_method_allele_list('consensus')
    >>> get_method_allele_list('recommended')

    """
    if method not in ['recommended', 'consensus']:
        raise ValueError('invalid method name: %s' % method)
    pickle_filename = 'pickles/%s_allele_available_method_2017-02-23.p' % method
    pickle_filepath = resource_filename(package_name, pickle_filename)
    with open(pickle_filepath, 'rb') as pfile:
        result_data = pickle.load(pfile)
    return result_data


