"""
created on 11/18/2019
@author: Yan
"""
from unittest import TestCase
from netmhcpan_4_0_executable import predict_many

class NetMHCpanExecutableTest(TestCase):
    '''test cases for netmhcpan 4.0 and netmhcpan_el 4.0'''
    def test_basic(self):
        allele_name = 'HLA-A*02:01'
        binding_length = '9'
        sequence = "SLYNTVATLYCVHQRIDV"

        sequence_list = [sequence,]
        allele_length_2tuple_list = [(allele_name, binding_length),]

        results = predict_many(sequence_list, allele_length_2tuple_list)
        print('Results:\n{}'.format(results))
        scores = list(results.values())
        expected_scores = [[165.7, 'SLYNTVATL', 'SLYNTVATL', 30111.3, 'LYNTVATLY', 'LYNTVATLY', 29454.9, 'YNTVATLYC', 'YNTVATLYC', 93.9, 'NTVATLYCV', 'NTVATLYCV', 36100.0, 'TVATLYCVH', 'TVATLYCVH', 31713.4, 'VATLYCVHQ', 'VATLYCVHQ', 28609.6, 'ATLYCVHQR', 'ATLYCVHQR', 266.8, 'TLYCVHQRI', 'TLYCVHQRI', 46144.3, 'LYCVHQRID', 'LYCVHQRID', 22125.3, 'YCVHQRIDV', 'YCVHQRIDV']]

        self.assertEqual(expected_scores, scores)

    def test_el(self):
        allele_name = 'HLA-A*02:01'
        binding_length = '9'
        sequence = "SLYNTVATLYCVHQRIDV"

        sequence_list = [sequence,]
        allele_length_2tuple_list = [(allele_name, binding_length),]

        results = predict_many(sequence_list, allele_length_2tuple_list, el=True)
        print('Results:\n{}'.format(results))
        scores = list(results.values())
        expected_scores = [[0.752161, 'SLYNTVATL', 'SLYNTVATL', 0.001971, 'LYNTVATLY', 'LYNTVATLY', 0.00013, 'YNTVATLYC', 'YNTVATLYC', 0.046794, 'NTVATLYCV', 'NTVATLYCV', 2.6e-05, 'TVATLYCVH', 'TVATLYCVH', 3.7e-05, 'VATLYCVHQ', 'VATLYCVHQ', 0.000235, 'ATLYCVHQR', 'ATLYCVHQR', 0.147491, 'TLYCVHQRI', 'TLYCVHQRI', 0.0, 'LYCVHQRID', 'LYCVHQRID', 0.001182, 'YCVHQRIDV', 'YCVHQRIDV']]

        self.assertEqual(expected_scores, scores)
