import os
from setuptools import setup, find_packages

# allow setup.py to be run from any path
os.chdir(os.path.normpath(os.path.join(os.path.abspath(__file__), os.pardir)))


# Get all of the Linux_x86_64/ data/ test/ files for use as package data
def recursive_walk(startdir):
    file_list = []
    for dirname, subdirList, fileList in os.walk(startdir, followlinks=True):
        if '.svn' in subdirList:
            subdirList.remove('.svn')
        for fname in fileList:
            file_list.append(os.path.join(dirname, fname))
            for sdname in subdirList:
                sdfiles = recursive_walk(sdname)
                file_list.extend(sdfiles)
    return file_list

pkg_data_files = ['netMHCpan', 'netMHCpan.1', 'netMHCpan-4.1.readme']
os.chdir('netmhcpan_4_1_executable')

for subdir in ['data', 'Linux_x86_64', 'test']:
    file_list = recursive_walk(subdir)
    pkg_data_files.extend(file_list)
os.chdir(os.pardir)

with open(os.path.join(os.path.dirname(__file__), 'README.rst')) as readme:
    README = readme.read()

setup(
    name="netmhcpan-4.1-executable",
    version="4.1.0.4",
    author='Zhen Yan',
    author_email='jyan@lji.org',
    packages=['netmhcpan_4_1_executable'],
    package_data={'netmhcpan_4_1_executable': pkg_data_files},
    description='Python package to provide netMHCpan-4.1 executable',
    long_description=README,
    install_requires=['allele-info>=3.8.0', 'iedbtools-utilities>=0.11.1'],
    keywords='T cell epitope prediction',
    classifiers=[
        'Intended Audience :: Developers',
        'Operating System :: POSIX :: Linux',
        'Programming Language :: Python :: 3',
    ]
)
