import os
from setuptools import setup, find_packages

# allow setup.py to be run from any path
os.chdir(os.path.normpath(os.path.join(os.path.abspath(__file__), os.pardir)))

# Get all of the Linux_i686/ Linux_x86_64/ test/ files for use as package data
def recursive_walk(startdir):
    file_list = []
    for dirname, subdirList, fileList in os.walk(startdir, followlinks=True):
	for fname in fileList:
            file_list.append(os.path.join(dirname, fname))
        for sdname in subdirList:
            sdfiles = recursive_walk(sdname)
            file_list.extend(sdfiles)
    return file_list

pkg_data_files = ['netMHC', 'netMHC.1','netMHC-4.0.readme']
os.chdir('netmhc_4_0_executable')
for subdir in ['data', 'Linux_i686', 'Linux_x86_64', 'test']:
    file_list = recursive_walk(subdir)
    pkg_data_files.extend(file_list)
os.chdir(os.pardir)

with open(os.path.join(os.path.dirname(__file__), 'README.rst')) as readme:
    README = readme.read()

setup(
    name = "netmhc-4.0-executable",
    version = "4.0.1",
    packages = ['netmhc_4_0_executable'],
    package_data = {'netmhc_4_0_executable': pkg_data_files},
    description = 'Python package to provide netMHC executable',
    long_description = README,
    classifiers = [
        'Intended Audience :: Developers',
        'Operating System :: POSIX :: Linux',
        'Programming Language :: Python :: 2',
    ]
)

