import os
from setuptools import setup, find_packages

# allow setup.py to be run from any path
os.chdir(os.path.normpath(os.path.join(os.path.abspath(__file__), os.pardir)))

# Get all of the data/ Linux_x86_64/ src/ test/ files for use as package data
def recursive_walk(startdir):
    file_list = []
    for dirname, subdirList, fileList in os.walk(startdir, followlinks=True):
	for fname in fileList:
            file_list.append(os.path.join(dirname, fname))
        for sdname in subdirList:
            sdfiles = recursive_walk(sdname)
            file_list.extend(sdfiles)
    return file_list

pkg_data_files = ['netMHCpan', 'netMHCpan.1']
os.chdir('netmhcpan_2_8_executable')
for subdir in ['data', 'Linux_x86_64', 'src', 'test']:
    file_list = recursive_walk(subdir)
    pkg_data_files.extend(file_list)
os.chdir(os.pardir)

with open(os.path.join(os.path.dirname(__file__), 'README.rst')) as readme:
    README = readme.read()

setup(
    name="netmhcpan-2.8-executable",
    version="0.6.1",
    packages=['netmhcpan_2_8_executable' ],
    package_data={ 'netmhcpan_2_8_executable': pkg_data_files },
    description='Python package to provide netmhcpan executable',
    long_description=README,
    install_requires=['allele-info>=2.5', 'iedbtools-utilities>=0.7'],
    classifiers=[
        'Intended Audience :: Developers',
        'Operating System :: POSIX :: Linux',
        'Programming Language :: Python :: 2',
    ]
)

