from netmhcpan_3_0_executable import predict_many

def netmhcpan_test(input_fasta_list, input_params):
    # scores is an ordered dictionary of input name(key) and tuples of prediction scores(value)
    threshold = input_params['threshold']
    method = input_params['method']
    short = input_params['short']
    
    # when allele name is used 
    scores = predict_many(input_fasta_list, [('HLA-A02:01','9')])

    # when user defined allele sequence is used
#     scores = predict_many(input_fasta_list, [('MLVMAPRTVLLLLSAALALTETWAGSHSMRYFYTSVSRPGRGEPRFISVGYVDDTQFVRFDSDAASPREEPRAPWIEQEGPEYWDRNTQIYKAQAQTDRESLRNLRGYYNQSEAGSHTLQSMYGCDVGPDGRLLRGHDQYAYDGKDYIALNEDLRSWTAADTAAQITQRKWEAAREAEQRRAYLEGECVEWLRRYLENGKDKLERADPPKTHVTHHPISDHEATLRCWALGFYPAEITLTWQRDGEDQTQDTELVETRPAGDRTFQKWAAVVVPSGEEQRYTCHVQHEGLPKPLTLRWEPSSQSTVPIVGIVAGLAVLAVVVIGAVVAAVMCRRKSSGGKGGSYSQAACSDSAQGSDVSLTA','9')])
    
    for i, key in enumerate(scores.keys(), start=1):
        print("key {}: {}\nvalue {}: {}".format(i, key, i, scores[key]))

if __name__ == '__main__':
    """
    #Optional named input parameters:
    #threshold(default='0.500000'), method(default='0') and short(default=False)
    """
    input_fasta_list = ["MSLLTEVETPIRNEWGCRCN"]
    
    input_params = {
        'threshold':'0.500000', 
        'method':'0', 
        'short':False
    }
    netmhcpan_test(input_fasta_list, input_params)