import os
from setuptools import setup

# allow setup.py to be run from any path
os.chdir(os.path.normpath(os.path.join(os.path.abspath(__file__), os.pardir)))

def read(fname):
    return open(os.path.join(os.path.dirname(__file__), fname)).read()

def recursive_walk(startdir):
    file_list = []
    for dirname, subdirList, fileList in os.walk(startdir, followlinks=True):
        for fname in fileList:
            file_list.append(os.path.join(dirname, fname))
            for sdname in subdirList:
                sdfiles = recursive_walk(sdname)
                file_list.extend(sdfiles)
    return file_list

# Collect the paths of all the data files for package_data.
os.chdir('allele_info/')
data_files = recursive_walk('pickles')
os.chdir(os.pardir)

setup(
    name='allele-info',
    version='4.0.1',
    description='An interface for collecting detailed allele information.',
    long_description=read('README.rst'),
    packages=['allele_info'],
    package_data={
        'allele_info': data_files 
    },
    classifiers=[
        'Intended Audience :: Developers',
        'Programming Language :: Python :: 2.7',
    ],
)
