from __future__ import print_function
import os
from setuptools import setup, find_packages

# allow setup.py to be run from any path
os.chdir(os.path.normpath(os.path.join(os.path.abspath(__file__), os.pardir)))

# README file
with open('README.rst', 'r') as rmf:
    README = rmf.read()

setup(
    name = "mhci-netmhcpan-4.0-percentile-data",
    version = "1.0.0",
    author = "Jason Yan",
    author_email = "jyan@lji.org",
    packages = ['mhci_netmhcpan_4_0_percentile_data'],
    package_data = {
        'mhci_netmhcpan_4_0_percentile_data': [
            'netmhcpan_percentile_distribution_2018-01-15.p'
        ],
    },
    description = 'Percentile data for mhci NetMHCPanPredictor 4.0',
    long_description = README,
    classifiers = [
        'Intended Audience :: Developers',
        'Operating System :: POSIX :: Linux',
        'Programming Language :: Python :: 2',
    ],
)
