import os, sys
from setuptools import setup

# generate netMHCcons script from template file which contents the valid python executable path 
TEMPLATE_NAME = 'netMHCcons.template'
SCRIPT_NAME = 'netMHCcons'

template_file = os.path.join(os.path.dirname(os.path.abspath(__file__)), 'netmhccons_1_1_executable', TEMPLATE_NAME)
script_file = os.path.join(os.path.dirname(os.path.abspath(__file__)), 'netmhccons_1_1_executable', SCRIPT_NAME)

with open(template_file) as f:
    template_content = f.read()
    content = template_content % sys.executable
    
with open(script_file, 'w') as f:
    f.write(content)

# allow setup.py to be run from any path
os.chdir(os.path.normpath(os.path.join(os.path.abspath(__file__), os.pardir)))

# Get all of the NetMHCIIPan executable's support files for package_data
def recursive_walk(startdir):
    file_list = []
    for dirname, subdirList, fileList in os.walk(startdir, followlinks=True):
        for fname in fileList:
            file_list.append(os.path.join(dirname, fname))
            for sdname in subdirList:
                sdfiles = recursive_walk(sdname)
                file_list.extend(sdfiles)
    return file_list

# Make a list of all of the non-python files in netmhccons_1_1_executable.
os.chdir('netmhccons_1_1_executable')
pkg_data_files = ['netMHCcons', 'netMHCcons.template', 'NETMHCcons.uu', 'NetMHCcons-1.1.pl']
for subdir in ['bin', 'data', 'src', 'test']:
    file_list = recursive_walk(subdir)
    pkg_data_files.extend(file_list)
os.chdir(os.pardir)

with open(os.path.join(os.path.dirname(__file__), 'README.rst')) as readme:
    README = readme.read()

setup(
    name="netmhccons-1.1-executable",
    version="0.0.3",
    packages=['netmhccons_1_1_executable' ],
    package_data={ 'netmhccons_1_1_executable': pkg_data_files },
    description='Python package to provide netmhccons executable',
    install_requires=[
        'iedbtools_utilities>=0.9', 'allele_info>=3.5',
        'netmhc-3.4-executable', 'netmhcpan-2.8-executable', 'pickpocket-1.1-executable',
    ],
    long_description=README,
    classifiers=[
        'Intended Audience :: Developers',
        'Operating System :: POSIX :: Linux',
        'Programming Language :: Python :: 2',
    ]
)
