from netmhcstabpan_1_0_executable import predict
     
def netmhcstabpan_test(input_seq, input_params):
    
    threshold = input_params['threshold']
    method = input_params['method']
    short = input_params['short']
    length = 10
    allele = 'Patr-A0101'
    
    scores = predict(allele, length, input_seq) # scores is a list
    i = 0
    for  score in scores:   
        print "peptied: %s, score: %s" % (input_seq[i:i+length], score)
        i+=1

def main():
    """
    #Optional named input parameters:
    #threshold(default='0.500000'), method(default='0') and short(default=False)
    """
    input_fasta = "MSLLTEVETPIRNEWGCRCN"
    
    input_params = {
        'threshold':'0.500000', 
        'method':'0', 
        'short':False
    }
    netmhcstabpan_test(input_fasta, input_params)


if __name__ == '__main__':
    main()
