#! /usr/bin/env python
"""
*Created on: ?
*Modified by: Dorjee Gyaltsen (07.01.2016, 04.12.2017,)
*brief: This script will set appropriate directory paths for -
    NetMHCpan, PickPocket, NetMHCcons methods.
"""
from __future__ import print_function
from distutils.spawn import find_executable
from shutil import copy2

import sys
import os

class Configure(object):

    def __init__(self, version="20130222"):
        self.version = version
        self.project_dir = os.path.abspath(".")
        self.src = os.path.join(self.project_dir, "src")
        self.method = os.path.join(self.project_dir, "method")

    def generate_setupinfo(self):
        tf = open(os.path.join(self.src, "setupinfo.template"), "r")
        content_template = tf.read()
        content = content_template % self.project_dir
        tf.close()

        of = open(os.path.join(self.src, "setupinfo.py"), "w")
        of.write(content)
        of.close()

    def update_netmhccons(self):
        #move the netMHCcons.template into place
        print("Copying the standalone-specific netMHCcons template into place")
        src_dir = os.path.dirname(os.path.realpath(__file__))
        netmhccons_template = src_dir + '/../method/netMHCcons.template'
        netmhccons_dest = src_dir + '/../method/netmhccons-1.1-executable/netmhccons_1_1_executable/netMHCcons'
        copy2(netmhccons_template, netmhccons_dest)
        

    def check_prerequisites(self):
        prerequisites = ["tcsh", "gawk"]
        for prereq in prerequisites:
            executable = find_executable(prereq)
            if not executable:
                print("* prerequisite: '{}' is not found in your path.  Please install and then rerun the configure script".format(prereq))
                sys.exit(1)
        # if we get here, all prerequisites have been found
        print("All prerequisites found!")

if __name__ == "__main__":
    config = Configure()
    config.generate_setupinfo()
    config.check_prerequisites()
    config.update_netmhccons()
    print("IEDB MHC class I binding prediction tools successfully installed!")
    print("Use the command 'python src/predict_binding.py' to get started")
