#! /usr/bin/python
import os
import sys
import unittest
from distutils.spawn import find_executable

class Test_test(unittest.TestCase):

    def test_example(self):
        self.assertEqual(1,1) 

    def test_os_popen_example(self):
        result=os.popen('echo example').read()
        self.assertEqual(result, 'example\n')

    def test_consensus(self):        
        cmd='python mhc_II_binding.py consensus3 HLA-DRB1*03:01 test.fasta'
        result=os.popen(cmd).read()        
        self.assertEqual(result, 'allele\tseq_num\tstart\tend\tlength\tpeptide\tconsensus_percentile_rank\tadjusted_consensus_percentile_rank\tcomblib_core\tcomblib_score\tcomblib_rank\tadjusted_comblib_rank\tsmm_align_core\tsmm_align_ic50\tsmm_align_rank\tadjusted_smm_align_rank\tnn_align_core\tnn_align_ic50\tnn_align_rank\tadjusted_nn_align_rank\tsturniolo_core\tsturniolo_score\tsturniolo_rank\tadjusted_sturniolo_rank\nHLA-DRB1*03:01\t1\t8\t22\t15\tEGVSGATWVDLVLEG\t59.0\t59.00\t-\t-\t-\t-\tVSGATWVDL\t5932.0\t59.0\t59.00\tTWVDLVLEG\t3356.9\t50.0\t50.00\tVSGATWVDL\t-1.34\t88.0\t88.00\nHLA-DRB1*03:01\t1\t4\t18\t15\tRDFLEGVSGATWVDL\t85.0\t85.00\t-\t-\t-\t-\tFLEGVSGAT\t8523.0\t69.0\t69.00\tVSGATWVDL\t12707.7\t85.0\t85.00\tFLEGVSGAT\t-1.2\t87.0\t87.00\nHLA-DRB1*03:01\t1\t5\t19\t15\tDFLEGVSGATWVDLV\t85.0\t85.00\t-\t-\t-\t-\tFLEGVSGAT\t18841.0\t85.0\t85.00\tVSGATWVDL\t10634.4\t81.0\t81.00\tFLEGVSGAT\t-1.2\t87.0\t87.00\nHLA-DRB1*03:01\t1\t6\t20\t15\tFLEGVSGATWVDLVL\t85.0\t85.00\t-\t-\t-\t-\tFLEGVSGAT\t18363.0\t85.0\t85.00\tVSGATWVDL\t8154.8\t74.0\t74.00\tFLEGVSGAT\t-1.2\t87.0\t87.00\nHLA-DRB1*03:01\t1\t1\t15\t15\tMSNRDFLEGVSGATW\t87.0\t87.00\t-\t-\t-\t-\tFLEGVSGAT\t9343.0\t71.0\t71.00\tDFLEGVSGA\t17372.9\t92.0\t92.00\tFLEGVSGAT\t-1.2\t87.0\t87.00\nHLA-DRB1*03:01\t1\t2\t16\t15\tSNRDFLEGVSGATWV\t87.0\t87.00\t-\t-\t-\t-\tFLEGVSGAT\t8986.0\t70.0\t70.00\tDFLEGVSGA\t18531.9\t93.0\t93.00\tFLEGVSGAT\t-1.2\t87.0\t87.00\nHLA-DRB1*03:01\t1\t3\t17\t15\tNRDFLEGVSGATWVD\t87.0\t87.00\t-\t-\t-\t-\tFLEGVSGAT\t9085.0\t70.0\t70.00\tDFLEGVSGA\t18458.2\t93.0\t93.00\tFLEGVSGAT\t-1.2\t87.0\t87.00\nHLA-DRB1*03:01\t1\t7\t21\t15\tLEGVSGATWVDLVLE\t88.0\t88.00\t-\t-\t-\t-\tSGATWVDLV\t26621.0\t91.0\t91.00\tVSGATWVDL\t5473.3\t63.0\t63.00\tVSGATWVDL\t-1.34\t88.0\t88.00\n')

    def test_recommended(self):        
        cmd='python mhc_II_binding.py IEDB_recommended HLA-DRB1*03:01 test.fasta'
        result=os.popen(cmd).read()        
        self.assertEqual(result, 'allele\tseq_num\tstart\tend\tlength\tmethod\tpeptide\tconsensus_percentile_rank\tadjusted_consensus_percentile_rank\tcomblib_core\tcomblib_score\tcomblib_rank\tadjusted_comblib_rank\tsmm_align_core\tsmm_align_ic50\tsmm_align_rank\tadjusted_smm_align_rank\tnn_align_core\tnn_align_ic50\tnn_align_rank\tadjusted_nn_align_rank\tnetmhciipan_core\tnetmhciipan_ic50\tnetmhciipan_rank\tadjusted_netmhciipan_rank\tsturniolo_core\tsturniolo_score\tsturniolo_rank\tadjusted_sturniolo_rank\nHLA-DRB1*03:01\t1\t8\t22\t15\tSMM-NN-Sturniolo\tEGVSGATWVDLVLEG\t59.0\t59.00\t-\t-\t-\t-\tVSGATWVDL\t5932.0\t59.0\t59.00\tTWVDLVLEG\t3356.9\t50.0\t50.00\t-\t-\t-\t-\tVSGATWVDL\t-1.34\t88.0\t88.00\nHLA-DRB1*03:01\t1\t4\t18\t15\tSMM-NN-Sturniolo\tRDFLEGVSGATWVDL\t85.0\t85.00\t-\t-\t-\t-\tFLEGVSGAT\t8523.0\t69.0\t69.00\tVSGATWVDL\t12707.7\t85.0\t85.00\t-\t-\t-\t-\tFLEGVSGAT\t-1.2\t87.0\t87.00\nHLA-DRB1*03:01\t1\t5\t19\t15\tSMM-NN-Sturniolo\tDFLEGVSGATWVDLV\t85.0\t85.00\t-\t-\t-\t-\tFLEGVSGAT\t18841.0\t85.0\t85.00\tVSGATWVDL\t10634.4\t81.0\t81.00\t-\t-\t-\t-\tFLEGVSGAT\t-1.2\t87.0\t87.00\nHLA-DRB1*03:01\t1\t6\t20\t15\tSMM-NN-Sturniolo\tFLEGVSGATWVDLVL\t85.0\t85.00\t-\t-\t-\t-\tFLEGVSGAT\t18363.0\t85.0\t85.00\tVSGATWVDL\t8154.8\t74.0\t74.00\t-\t-\t-\t-\tFLEGVSGAT\t-1.2\t87.0\t87.00\nHLA-DRB1*03:01\t1\t1\t15\t15\tSMM-NN-Sturniolo\tMSNRDFLEGVSGATW\t87.0\t87.00\t-\t-\t-\t-\tFLEGVSGAT\t9343.0\t71.0\t71.00\tDFLEGVSGA\t17372.9\t92.0\t92.00\t-\t-\t-\t-\tFLEGVSGAT\t-1.2\t87.0\t87.00\nHLA-DRB1*03:01\t1\t2\t16\t15\tSMM-NN-Sturniolo\tSNRDFLEGVSGATWV\t87.0\t87.00\t-\t-\t-\t-\tFLEGVSGAT\t8986.0\t70.0\t70.00\tDFLEGVSGA\t18531.9\t93.0\t93.00\t-\t-\t-\t-\tFLEGVSGAT\t-1.2\t87.0\t87.00\nHLA-DRB1*03:01\t1\t3\t17\t15\tSMM-NN-Sturniolo\tNRDFLEGVSGATWVD\t87.0\t87.00\t-\t-\t-\t-\tFLEGVSGAT\t9085.0\t70.0\t70.00\tDFLEGVSGA\t18458.2\t93.0\t93.00\t-\t-\t-\t-\tFLEGVSGAT\t-1.2\t87.0\t87.00\nHLA-DRB1*03:01\t1\t7\t21\t15\tSMM-NN-Sturniolo\tLEGVSGATWVDLVLE\t88.0\t88.00\t-\t-\t-\t-\tSGATWVDLV\t26621.0\t91.0\t91.00\tVSGATWVDL\t5473.3\t63.0\t63.00\t-\t-\t-\t-\tVSGATWVDL\t-1.34\t88.0\t88.00\n')

    def test_comblib(self):        
        cmd='python mhc_II_binding.py comblib HLA-DRB1*01:01 test.fasta'
        result=os.popen(cmd).read()        
        self.assertEqual(result, 'allele\tseq_num\tstart\tend\tlength\tcore_peptide\tpeptide\tic50\tpercentile_rank\tadjusted_rank\nHLA-DRB1*01:01\t1\t1\t15\t15\tFLEGVSGAT\tMSNRDFLEGVSGATW\t1.61\t20.0\t20.00\nHLA-DRB1*01:01\t1\t2\t16\t15\tFLEGVSGAT\tSNRDFLEGVSGATWV\t1.61\t20.0\t20.00\nHLA-DRB1*01:01\t1\t3\t17\t15\tFLEGVSGAT\tNRDFLEGVSGATWVD\t1.61\t20.0\t20.00\nHLA-DRB1*01:01\t1\t4\t18\t15\tFLEGVSGAT\tRDFLEGVSGATWVDL\t1.61\t20.0\t20.00\nHLA-DRB1*01:01\t1\t5\t19\t15\tFLEGVSGAT\tDFLEGVSGATWVDLV\t1.61\t20.0\t20.00\nHLA-DRB1*01:01\t1\t6\t20\t15\tFLEGVSGAT\tFLEGVSGATWVDLVL\t1.61\t20.0\t20.00\nHLA-DRB1*01:01\t1\t7\t21\t15\tGATWVDLVL\tLEGVSGATWVDLVLE\t22370.75\t78.0\t78.00\nHLA-DRB1*01:01\t1\t8\t22\t15\tGATWVDLVL\tEGVSGATWVDLVLEG\t22370.75\t78.0\t78.00\n')

    def test_netmhciipan(self):        
        cmd='python mhc_II_binding.py NetMHCIIpan HLA-DRB1*03:01 test.fasta'
        result=os.popen(cmd).read()        
        self.assertEqual(result, 'allele\tseq_num\tstart\tend\tlength\tcore_peptide\tpeptide\tic50\tpercentile_rank\tadjusted_rank\nHLA-DRB1*03:01\t1\t8\t22\t15\tTWVDLVLEG\tEGVSGATWVDLVLEG\t6334.28\t71.0\t71.00\nHLA-DRB1*03:01\t1\t7\t21\t15\tVSGATWVDL\tLEGVSGATWVDLVLE\t8828.27\t82.0\t82.00\nHLA-DRB1*03:01\t1\t6\t20\t15\tVSGATWVDL\tFLEGVSGATWVDLVL\t8931.45\t82.0\t82.00\nHLA-DRB1*03:01\t1\t1\t15\t15\tLEGVSGATW\tMSNRDFLEGVSGATW\t9691.16\t84.0\t84.00\nHLA-DRB1*03:01\t1\t4\t18\t15\tLEGVSGATW\tRDFLEGVSGATWVDL\t10099.56\t85.0\t85.00\nHLA-DRB1*03:01\t1\t2\t16\t15\tLEGVSGATW\tSNRDFLEGVSGATWV\t10356.06\t86.0\t86.00\nHLA-DRB1*03:01\t1\t5\t19\t15\tLEGVSGATW\tDFLEGVSGATWVDLV\t10408.41\t86.0\t86.00\nHLA-DRB1*03:01\t1\t3\t17\t15\tLEGVSGATW\tNRDFLEGVSGATWVD\t12292.11\t90.0\t90.00\n'  )

    def test_nn(self):        
        cmd='python mhc_II_binding.py nn_align HLA-DRB1*03:01 test.fasta'
        result=os.popen(cmd).read()        
        self.assertEqual(result, 'allele\tseq_num\tstart\tend\tlength\tcore_peptide\tpeptide\tic50\tpercentile_rank\tadjusted_rank\nHLA-DRB1*03:01\t1\t8\t22\t15\tTWVDLVLEG\tEGVSGATWVDLVLEG\t3356.90\t50.0\t50.00\nHLA-DRB1*03:01\t1\t7\t21\t15\tVSGATWVDL\tLEGVSGATWVDLVLE\t5473.30\t63.0\t63.00\nHLA-DRB1*03:01\t1\t6\t20\t15\tVSGATWVDL\tFLEGVSGATWVDLVL\t8154.80\t74.0\t74.00\nHLA-DRB1*03:01\t1\t5\t19\t15\tVSGATWVDL\tDFLEGVSGATWVDLV\t10634.40\t81.0\t81.00\nHLA-DRB1*03:01\t1\t4\t18\t15\tVSGATWVDL\tRDFLEGVSGATWVDL\t12707.70\t85.0\t85.00\nHLA-DRB1*03:01\t1\t1\t15\t15\tDFLEGVSGA\tMSNRDFLEGVSGATW\t17372.90\t92.0\t92.00\nHLA-DRB1*03:01\t1\t3\t17\t15\tDFLEGVSGA\tNRDFLEGVSGATWVD\t18458.20\t93.0\t93.00\nHLA-DRB1*03:01\t1\t2\t16\t15\tDFLEGVSGA\tSNRDFLEGVSGATWV\t18531.90\t93.0\t93.00\n')

    def test_smm(self):        
        cmd='python mhc_II_binding.py smm_align HLA-DRB1*03:01 test.fasta'
        result=os.popen(cmd).read()        
        self.assertEqual(result, 'allele\tseq_num\tstart\tend\tlength\tcore_peptide\tpeptide\tic50\tpercentile_rank\tadjusted_rank\nHLA-DRB1*03:01\t1\t8\t22\t15\tVSGATWVDL\tEGVSGATWVDLVLEG\t5932.00\t59.0\t59.00\nHLA-DRB1*03:01\t1\t4\t18\t15\tFLEGVSGAT\tRDFLEGVSGATWVDL\t8523.00\t69.0\t69.00\nHLA-DRB1*03:01\t1\t2\t16\t15\tFLEGVSGAT\tSNRDFLEGVSGATWV\t8986.00\t70.0\t70.00\nHLA-DRB1*03:01\t1\t3\t17\t15\tFLEGVSGAT\tNRDFLEGVSGATWVD\t9085.00\t70.0\t70.00\nHLA-DRB1*03:01\t1\t1\t15\t15\tFLEGVSGAT\tMSNRDFLEGVSGATW\t9343.00\t71.0\t71.00\nHLA-DRB1*03:01\t1\t6\t20\t15\tFLEGVSGAT\tFLEGVSGATWVDLVL\t18363.00\t85.0\t85.00\nHLA-DRB1*03:01\t1\t5\t19\t15\tFLEGVSGAT\tDFLEGVSGATWVDLV\t18841.00\t85.0\t85.00\nHLA-DRB1*03:01\t1\t7\t21\t15\tSGATWVDLV\tLEGVSGATWVDLVLE\t26621.00\t91.0\t91.00\n')

    def test_sturniolo(self):        
        cmd='python mhc_II_binding.py sturniolo HLA-DRB1*03:01 test.fasta'
        result=os.popen(cmd).read()        
        self.assertEqual(result, 'allele\tseq_num\tstart\tend\tlength\tcore_peptide\tpeptide\tscore\tpercentile_rank\tadjusted_rank\nHLA-DRB1*03:01\t1\t1\t15\t15\tFLEGVSGAT\tMSNRDFLEGVSGATW\t-1.20\t87.0\t87.00\nHLA-DRB1*03:01\t1\t2\t16\t15\tFLEGVSGAT\tSNRDFLEGVSGATWV\t-1.20\t87.0\t87.00\nHLA-DRB1*03:01\t1\t3\t17\t15\tFLEGVSGAT\tNRDFLEGVSGATWVD\t-1.20\t87.0\t87.00\nHLA-DRB1*03:01\t1\t4\t18\t15\tFLEGVSGAT\tRDFLEGVSGATWVDL\t-1.20\t87.0\t87.00\nHLA-DRB1*03:01\t1\t5\t19\t15\tFLEGVSGAT\tDFLEGVSGATWVDLV\t-1.20\t87.0\t87.00\nHLA-DRB1*03:01\t1\t6\t20\t15\tFLEGVSGAT\tFLEGVSGATWVDLVL\t-1.20\t87.0\t87.00\nHLA-DRB1*03:01\t1\t7\t21\t15\tVSGATWVDL\tLEGVSGATWVDLVLE\t-1.34\t88.0\t88.00\nHLA-DRB1*03:01\t1\t8\t22\t15\tVSGATWVDL\tEGVSGATWVDLVLEG\t-1.34\t88.0\t88.00\n')



def check_prerequisites():
    prerequisites = ["tcsh", "gawk"]
    for prereq in prerequisites:
        executable = find_executable(prereq)
        if not executable:
            print("* prerequisite: '{}' is not found in your path.  Please install and then rerun the configure script".format(prereq))
            sys.exit(1)
    # if we get here, all prerequisites have been found
    print("All prerequisites found!")

def check_environment_variables():
    # check if TMPDIR exists & is writable by the current user
    TMPDIR = os.environ.get('TMPDIR', None)
    if not TMPDIR or not (os.path.isdir(TMPDIR) and os.access(TMPDIR, os.W_OK)):
        print( 'environemnt variable TMPDIR is not set.')
        if os.path.isdir('/tmp') and os.access('/tmp', os.W_OK):
            print( '/tmp will be used for temporary files')
        else:
            print("""* Warning: /tmp does not exists or is not writable. To set the TMPDIR environment variable, please specify a directory that is accessible to the user that runs the standalone tools.
For example, the following command specifies the /home/repldba/tempfiles/ directory:
export TMPDIR=/home/repldba/tempfiles/""")
            sys.exit(1)

def test():    
    unittest.main()

def main():
    check_prerequisites()
    check_environment_variables()
    print( 'run MHCII tests...')
    test()

if __name__ == '__main__':   
    main()
