# This is the script used to convert the comblib percentile files into a single
#   pickle file.
# TODO: Remove this after comblib percentile data is removed from
#    'djangotools/tool_data/MHCII/comblib'
import os
import re
import glob
import cPickle

original_dir = os.getcwd()
djangotools_dir = '/home/jivan/.projects/lji/djangotools'
percentile_dir = 'tool_data/MHCII/comblib'
percentile_dir_full_path = os.path.join(djangotools_dir, percentile_dir)
os.chdir(percentile_dir_full_path)
percentiles = {}

for filename in glob.glob('perc_*'):
    pattern = 'perc_(.*).txt'
    m = re.search(pattern, filename)
    allele_name = m.group(1)
    key = ('comblib', allele_name, 15)
    with open(filename) as perc_file:
        file_contents = perc_file.read()
    score_list = [float(a) for a in file_contents.split()]

    percentiles[key] = score_list

os.chdir(original_dir)

with open('comblib_percentile_distribution_2008-01-23.p', 'w+') as pickle_file:
    cPickle.dump(percentiles, pickle_file)
