import os
from setuptools import setup

# allow setup.py to be run from any path
os.chdir(os.path.normpath(os.path.join(os.path.abspath(__file__), os.pardir)))

with open(os.path.join(os.path.dirname(__file__), 'README.rst')) as readme:
    README = readme.read()

setup(
    name="mhcii_comblib_predictor",
    version="1.0.0",
    packages=['mhcii_comblib_predictor' ],
    package_data={
        'mhcii_comblib_predictor': [
            'comblib_predictor_data_pre_2016-02-12.p',
        ],
    },
    test_suite = 'tests',
    description='PyPA package for mhcii comblib prediction which also have interface to provide data needed for mhcii comblib analyses.',
    long_description=README,
    # Important only if the package will be widely distributed.  See more at:
    #    https://pypi.python.org/pypi?%3Aaction=list_classifiers
    classifiers=[
        'Intended Audience :: Developers',
        'Operating System :: POSIX :: Linux',
        'Programming Language :: Python :: 3',
    ]
)
